/*
 * Decompiled with CFR 0.152.
 */
package me.teakivy.teakstweaks.utils.update;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import me.teakivy.teakstweaks.utils.update.Version;
import org.apache.commons.io.IOUtils;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;
import org.json.simple.parser.ParseException;

public class VersionManager {
    private static final List<Version> versions = new ArrayList<Version>();

    public static void init() {
        versions.clear();
        String url = "https://api.modrinth.com/v2/project/Xdn5t532/version";
        try {
            String nameJson = IOUtils.toString((URL)new URL(url));
            JSONArray versions = (JSONArray)JSONValue.parseWithException((String)nameJson);
            for (Object version : versions) {
                JSONObject obj = (JSONObject)version;
                Version v = VersionManager.parseVersion(obj);
                VersionManager.versions.add(v);
            }
        }
        catch (IOException | ParseException throwable) {
            // empty catch block
        }
    }

    private static Version parseVersion(JSONObject obj) {
        String version = (String)obj.get((Object)"version_number");
        String id = (String)obj.get((Object)"id");
        ArrayList<String> supportedMCVersions = new ArrayList<String>();
        JSONArray supportedVersions = (JSONArray)obj.get((Object)"game_versions");
        for (Object supportedVersion : supportedVersions) {
            supportedMCVersions.add((String)supportedVersion);
        }
        return new Version(version, supportedMCVersions, id);
    }

    public static List<Version> getVersions() {
        return versions;
    }

    public static Version getBestVersion() {
        ArrayList<Version> supportedVersions = new ArrayList<Version>();
        for (Version version : versions) {
            if (!version.isSupported()) continue;
            supportedVersions.add(version);
        }
        if (supportedVersions.isEmpty()) {
            return null;
        }
        Version bestVersion = (Version)supportedVersions.getFirst();
        for (Version version : supportedVersions) {
            if (bestVersion.isNewerThan(version)) continue;
            bestVersion = version;
        }
        return bestVersion;
    }
}

