/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.musicdiscexpansion.item;

import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.mcreator.musicdiscexpansion.item.inventory.DiscPackInventoryCapability;
import net.mcreator.musicdiscexpansion.world.inventory.DiscPackGUIMenu;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.network.NetworkHooks;

public class DiscPackItem
extends Item {
    public DiscPackItem() {
        super(new Item.Properties().m_41487_(1).m_41497_(Rarity.COMMON));
    }

    public void m_7373_(ItemStack itemstack, Level level, List<Component> list, TooltipFlag flag) {
        super.m_7373_(itemstack, level, list, flag);
        List<Component> lore = this.getLoreFromItemStack(itemstack);
        itemstack.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(handler -> {
            boolean hasItems = false;
            for (int i = 0; i < handler.getSlots(); ++i) {
                ItemStack stack = handler.getStackInSlot(i);
                if (stack.m_41619_()) continue;
                hasItems = true;
                list.add((Component)Component.m_237113_((String)("\u00a77" + stack.m_41786_().getString())));
                List<Component> stackLore = this.getLoreFromItemStack(stack);
                if (stackLore.isEmpty()) continue;
                for (Component loreLine : stackLore) {
                    list.add((Component)Component.m_237113_((String)"    ").m_7220_(loreLine));
                }
            }
            if (!hasItems) {
                list.add((Component)Component.m_237113_((String)"\u00a77Store your discs"));
            }
        });
        if (!lore.isEmpty()) {
            for (Component loreLine : lore) {
                list.add((Component)Component.m_237113_((String)"    ").m_7220_(loreLine));
            }
        }
    }

    private List<Component> getLoreFromItemStack(ItemStack stack) {
        CompoundTag displayTag;
        CompoundTag tag;
        ArrayList<Component> loreList = new ArrayList<Component>();
        if (stack.m_41782_() && (tag = stack.m_41783_()) != null && tag.m_128425_("display", 10) && (displayTag = tag.m_128469_("display")).m_128425_("Lore", 9)) {
            ListTag loreTag = displayTag.m_128437_("Lore", 8);
            for (int i = 0; i < loreTag.size(); ++i) {
                String loreString = loreTag.m_128778_(i);
                loreList.add((Component)Component.Serializer.m_130701_((String)loreString));
            }
        }
        return loreList;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, final Player entity, final InteractionHand hand) {
        InteractionResultHolder ar = super.m_7203_(world, entity, hand);
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            NetworkHooks.openScreen((ServerPlayer)serverPlayer, (MenuProvider)new MenuProvider(){

                public Component m_5446_() {
                    return Component.m_237113_((String)"Disc Pack");
                }

                public AbstractContainerMenu m_7208_(int id, Inventory inventory, Player player) {
                    FriendlyByteBuf packetBuffer = new FriendlyByteBuf(Unpooled.buffer());
                    packetBuffer.m_130064_(entity.m_20183_());
                    packetBuffer.writeByte(hand == InteractionHand.MAIN_HAND ? 0 : 1);
                    return new DiscPackGUIMenu(id, inventory, packetBuffer);
                }
            }, buf -> {
                buf.m_130064_(entity.m_20183_());
                buf.writeByte(hand == InteractionHand.MAIN_HAND ? 0 : 1);
            });
        }
        return ar;
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag compound) {
        return new DiscPackInventoryCapability();
    }

    public CompoundTag getShareTag(ItemStack stack) {
        CompoundTag nbt = stack.m_41784_();
        stack.getCapability(ForgeCapabilities.ITEM_HANDLER, null).ifPresent(capability -> nbt.m_128365_("Inventory", (Tag)((ItemStackHandler)capability).serializeNBT()));
        return nbt;
    }

    public void readShareTag(ItemStack stack, @Nullable CompoundTag nbt) {
        super.readShareTag(stack, nbt);
        if (nbt != null) {
            stack.getCapability(ForgeCapabilities.ITEM_HANDLER, null).ifPresent(capability -> ((ItemStackHandler)capability).deserializeNBT((CompoundTag)nbt.m_128423_("Inventory")));
        }
    }
}

