/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.musicdiscexpansion.network;

import java.util.HashMap;
import java.util.function.Supplier;
import net.mcreator.musicdiscexpansion.MusicDiscExpansionMod;
import net.mcreator.musicdiscexpansion.procedures.BlockSoundsButtonProcedure;
import net.mcreator.musicdiscexpansion.procedures.DiamondStarButtonProcedure;
import net.mcreator.musicdiscexpansion.procedures.FiveStarButtonProcedure;
import net.mcreator.musicdiscexpansion.procedures.FourStarButtonProcedure;
import net.mcreator.musicdiscexpansion.procedures.GoldStarButtonProcedure;
import net.mcreator.musicdiscexpansion.procedures.MusicBoxOnBlockRightClickedProcedure;
import net.mcreator.musicdiscexpansion.procedures.OneStarButtonProcedure;
import net.mcreator.musicdiscexpansion.procedures.SixStarButtonProcedure;
import net.mcreator.musicdiscexpansion.procedures.ThreeStarButtonProcedure;
import net.mcreator.musicdiscexpansion.procedures.TwoStarButtonProcedure;
import net.mcreator.musicdiscexpansion.world.inventory.MusicBoxGuiMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class MusicBoxGuiButtonMessage {
    private final int buttonID;
    private final int x;
    private final int y;
    private final int z;

    public MusicBoxGuiButtonMessage(FriendlyByteBuf buffer) {
        this.buttonID = buffer.readInt();
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
    }

    public MusicBoxGuiButtonMessage(int buttonID, int x, int y, int z) {
        this.buttonID = buttonID;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public static void buffer(MusicBoxGuiButtonMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }

    public static void handler(MusicBoxGuiButtonMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer entity = context.getSender();
            int buttonID = message.buttonID;
            int x = message.x;
            int y = message.y;
            int z = message.z;
            MusicBoxGuiButtonMessage.handleButtonAction((Player)entity, buttonID, x, y, z);
        });
        context.setPacketHandled(true);
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.m_9236_();
        HashMap<String, Object> guistate = MusicBoxGuiMenu.guistate;
        if (!world.m_46805_(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            MusicBoxOnBlockRightClickedProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 1) {
            DiamondStarButtonProcedure.execute((Entity)entity);
        }
        if (buttonID == 2) {
            GoldStarButtonProcedure.execute((Entity)entity);
        }
        if (buttonID == 3) {
            OneStarButtonProcedure.execute((Entity)entity);
        }
        if (buttonID == 4) {
            TwoStarButtonProcedure.execute((Entity)entity);
        }
        if (buttonID == 5) {
            ThreeStarButtonProcedure.execute((Entity)entity);
        }
        if (buttonID == 6) {
            FourStarButtonProcedure.execute((Entity)entity);
        }
        if (buttonID == 7) {
            FiveStarButtonProcedure.execute((Entity)entity);
        }
        if (buttonID == 8) {
            SixStarButtonProcedure.execute((Entity)entity);
        }
        if (buttonID == 9) {
            BlockSoundsButtonProcedure.execute((Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        MusicDiscExpansionMod.addNetworkMessage(MusicBoxGuiButtonMessage.class, MusicBoxGuiButtonMessage::buffer, MusicBoxGuiButtonMessage::new, MusicBoxGuiButtonMessage::handler);
    }
}

