/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.musicdiscexpansion.network;

import java.util.function.Supplier;
import net.mcreator.musicdiscexpansion.MusicDiscExpansionMod;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class MusicDiscExpansionModVariables {
    public static double songMaxScoreBlockSounds = 34320.0;
    public static double songMaxScoreIDVictory = 45600.0;
    public static final Capability<PlayerVariables> PLAYER_VARIABLES_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<PlayerVariables>(){});

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        MusicDiscExpansionMod.addNetworkMessage(SavedDataSyncMessage.class, SavedDataSyncMessage::buffer, SavedDataSyncMessage::new, SavedDataSyncMessage::handler);
        MusicDiscExpansionMod.addNetworkMessage(PlayerVariablesSyncMessage.class, PlayerVariablesSyncMessage::buffer, PlayerVariablesSyncMessage::new, PlayerVariablesSyncMessage::handler);
    }

    @SubscribeEvent
    public static void init(RegisterCapabilitiesEvent event) {
        event.register(PlayerVariables.class);
    }

    public static class SavedDataSyncMessage {
        private final int type;
        private SavedData data;

        public SavedDataSyncMessage(FriendlyByteBuf buffer) {
            this.type = buffer.readInt();
            CompoundTag nbt = buffer.m_130260_();
            if (nbt != null) {
                this.data = this.type == 0 ? new MapVariables() : new WorldVariables();
                SavedData savedData = this.data;
                if (savedData instanceof MapVariables) {
                    MapVariables mapVariables = (MapVariables)savedData;
                    mapVariables.read(nbt);
                } else {
                    savedData = this.data;
                    if (savedData instanceof WorldVariables) {
                        WorldVariables worldVariables = (WorldVariables)savedData;
                        worldVariables.read(nbt);
                    }
                }
            }
        }

        public SavedDataSyncMessage(int type, SavedData data) {
            this.type = type;
            this.data = data;
        }

        public static void buffer(SavedDataSyncMessage message, FriendlyByteBuf buffer) {
            buffer.writeInt(message.type);
            if (message.data != null) {
                buffer.m_130079_(message.data.m_7176_(new CompoundTag()));
            }
        }

        public static void handler(SavedDataSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer() && message.data != null) {
                    if (message.type == 0) {
                        MapVariables.clientSide = (MapVariables)message.data;
                    } else {
                        WorldVariables.clientSide = (WorldVariables)message.data;
                    }
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class PlayerVariablesSyncMessage {
        private final PlayerVariables data;

        public PlayerVariablesSyncMessage(FriendlyByteBuf buffer) {
            this.data = new PlayerVariables();
            this.data.readNBT((Tag)buffer.m_130260_());
        }

        public PlayerVariablesSyncMessage(PlayerVariables data) {
            this.data = data;
        }

        public static void buffer(PlayerVariablesSyncMessage message, FriendlyByteBuf buffer) {
            buffer.m_130079_((CompoundTag)message.data.writeNBT());
        }

        public static void handler(PlayerVariablesSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer()) {
                    PlayerVariables variables = (PlayerVariables)Minecraft.m_91087_().f_91074_.getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
                    variables.audioLatency = message.data.audioLatency;
                    variables.gamemodeSaved = message.data.gamemodeSaved;
                    variables.mmr = message.data.mmr;
                    variables.musicPercent = message.data.musicPercent;
                    variables.musicScore = message.data.musicScore;
                    variables.musicScoreMult = message.data.musicScoreMult;
                    variables.songID = message.data.songID;
                    variables.statNotesHit = message.data.statNotesHit;
                    variables.tutorialCompletion = message.data.tutorialCompletion;
                    variables.xpStored = message.data.xpStored;
                    variables.statGoldStars = message.data.statGoldStars;
                    variables.statDiamondStars = message.data.statDiamondStars;
                    variables.statScore = message.data.statScore;
                    variables.statSongsPlayed = message.data.statSongsPlayed;
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class PlayerVariables {
        public double audioLatency = 0.0;
        public double gamemodeSaved = 0.0;
        public double mmr = 0.0;
        public double musicPercent = 0.0;
        public double musicScore = 0.0;
        public double musicScoreMult = 0.0;
        public double songID = 1001.0;
        public double statNotesHit = 0.0;
        public double tutorialCompletion = 0.0;
        public double xpStored = 0.0;
        public double statGoldStars = 0.0;
        public double statDiamondStars = 0.0;
        public double statScore = 0.0;
        public double statSongsPlayed = 0.0;

        public void syncPlayerVariables(Entity entity) {
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                MusicDiscExpansionMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new PlayerVariablesSyncMessage(this));
            }
        }

        public Tag writeNBT() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128347_("audioLatency", this.audioLatency);
            nbt.m_128347_("gamemodeSaved", this.gamemodeSaved);
            nbt.m_128347_("mmr", this.mmr);
            nbt.m_128347_("musicPercent", this.musicPercent);
            nbt.m_128347_("musicScore", this.musicScore);
            nbt.m_128347_("musicScoreMult", this.musicScoreMult);
            nbt.m_128347_("songID", this.songID);
            nbt.m_128347_("statNotesHit", this.statNotesHit);
            nbt.m_128347_("tutorialCompletion", this.tutorialCompletion);
            nbt.m_128347_("xpStored", this.xpStored);
            nbt.m_128347_("statGoldStars", this.statGoldStars);
            nbt.m_128347_("statDiamondStars", this.statDiamondStars);
            nbt.m_128347_("statScore", this.statScore);
            nbt.m_128347_("statSongsPlayed", this.statSongsPlayed);
            return nbt;
        }

        public void readNBT(Tag tag) {
            CompoundTag nbt = (CompoundTag)tag;
            this.audioLatency = nbt.m_128459_("audioLatency");
            this.gamemodeSaved = nbt.m_128459_("gamemodeSaved");
            this.mmr = nbt.m_128459_("mmr");
            this.musicPercent = nbt.m_128459_("musicPercent");
            this.musicScore = nbt.m_128459_("musicScore");
            this.musicScoreMult = nbt.m_128459_("musicScoreMult");
            this.songID = nbt.m_128459_("songID");
            this.statNotesHit = nbt.m_128459_("statNotesHit");
            this.tutorialCompletion = nbt.m_128459_("tutorialCompletion");
            this.xpStored = nbt.m_128459_("xpStored");
            this.statGoldStars = nbt.m_128459_("statGoldStars");
            this.statDiamondStars = nbt.m_128459_("statDiamondStars");
            this.statScore = nbt.m_128459_("statScore");
            this.statSongsPlayed = nbt.m_128459_("statSongsPlayed");
        }
    }

    @Mod.EventBusSubscriber
    private static class PlayerVariablesProvider
    implements ICapabilitySerializable<Tag> {
        private final PlayerVariables playerVariables = new PlayerVariables();
        private final LazyOptional<PlayerVariables> instance = LazyOptional.of(() -> this.playerVariables);

        private PlayerVariablesProvider() {
        }

        @SubscribeEvent
        public static void onAttachCapabilities(AttachCapabilitiesEvent<Entity> event) {
            if (event.getObject() instanceof Player && !(event.getObject() instanceof FakePlayer)) {
                event.addCapability(new ResourceLocation("music_disc_expansion", "player_variables"), (ICapabilityProvider)new PlayerVariablesProvider());
            }
        }

        public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
            return cap == PLAYER_VARIABLES_CAPABILITY ? this.instance.cast() : LazyOptional.empty();
        }

        public Tag serializeNBT() {
            return this.playerVariables.writeNBT();
        }

        public void deserializeNBT(Tag nbt) {
            this.playerVariables.readNBT(nbt);
        }
    }

    public static class MapVariables
    extends SavedData {
        public static final String DATA_NAME = "music_disc_expansion_mapvars";
        public boolean festivalLoaded = false;
        public double monthStarted = 0.0;
        public boolean player10Available = true;
        public boolean player11Available = true;
        public boolean player1Available = true;
        public boolean player2Available = true;
        public boolean player3Available = true;
        public boolean player4Available = true;
        public boolean player5Available = true;
        public boolean player6Available = true;
        public boolean player7Available = true;
        public boolean player8Available = true;
        public boolean player9Available = true;
        public double time = 0.0;
        public String versusFirst = "\"--- 0\"";
        public double versusFirstMMR = 0.0;
        public double victoryScore = 45360.0;
        static MapVariables clientSide = new MapVariables();

        public static MapVariables load(CompoundTag tag) {
            MapVariables data = new MapVariables();
            data.read(tag);
            return data;
        }

        public void read(CompoundTag nbt) {
            this.festivalLoaded = nbt.m_128471_("festivalLoaded");
            this.monthStarted = nbt.m_128459_("monthStarted");
            this.player10Available = nbt.m_128471_("player10Available");
            this.player11Available = nbt.m_128471_("player11Available");
            this.player1Available = nbt.m_128471_("player1Available");
            this.player2Available = nbt.m_128471_("player2Available");
            this.player3Available = nbt.m_128471_("player3Available");
            this.player4Available = nbt.m_128471_("player4Available");
            this.player5Available = nbt.m_128471_("player5Available");
            this.player6Available = nbt.m_128471_("player6Available");
            this.player7Available = nbt.m_128471_("player7Available");
            this.player8Available = nbt.m_128471_("player8Available");
            this.player9Available = nbt.m_128471_("player9Available");
            this.time = nbt.m_128459_("time");
            this.versusFirst = nbt.m_128461_("versusFirst");
            this.versusFirstMMR = nbt.m_128459_("versusFirstMMR");
            this.victoryScore = nbt.m_128459_("victoryScore");
        }

        public CompoundTag m_7176_(CompoundTag nbt) {
            nbt.m_128379_("festivalLoaded", this.festivalLoaded);
            nbt.m_128347_("monthStarted", this.monthStarted);
            nbt.m_128379_("player10Available", this.player10Available);
            nbt.m_128379_("player11Available", this.player11Available);
            nbt.m_128379_("player1Available", this.player1Available);
            nbt.m_128379_("player2Available", this.player2Available);
            nbt.m_128379_("player3Available", this.player3Available);
            nbt.m_128379_("player4Available", this.player4Available);
            nbt.m_128379_("player5Available", this.player5Available);
            nbt.m_128379_("player6Available", this.player6Available);
            nbt.m_128379_("player7Available", this.player7Available);
            nbt.m_128379_("player8Available", this.player8Available);
            nbt.m_128379_("player9Available", this.player9Available);
            nbt.m_128347_("time", this.time);
            nbt.m_128359_("versusFirst", this.versusFirst);
            nbt.m_128347_("versusFirstMMR", this.versusFirstMMR);
            nbt.m_128347_("victoryScore", this.victoryScore);
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            this.m_77762_();
            if (world instanceof Level && !world.m_5776_()) {
                MusicDiscExpansionMod.PACKET_HANDLER.send(PacketDistributor.ALL.noArg(), (Object)new SavedDataSyncMessage(0, this));
            }
        }

        public static MapVariables get(LevelAccessor world) {
            if (world instanceof ServerLevelAccessor) {
                ServerLevelAccessor serverLevelAcc = (ServerLevelAccessor)world;
                return (MapVariables)serverLevelAcc.m_6018_().m_7654_().m_129880_(Level.f_46428_).m_8895_().m_164861_(e -> MapVariables.load(e), MapVariables::new, DATA_NAME);
            }
            return clientSide;
        }
    }

    public static class WorldVariables
    extends SavedData {
        public static final String DATA_NAME = "music_disc_expansion_worldvars";
        public double fiveStarSongs = 1.0;
        public double fourStarSongs = 1.0;
        public double oneStarSongs = 1.0;
        public double otherSongs = 2.0;
        public double sevenStarSongs = 1.0;
        public double sixStarSongs = 0.0;
        public double threeStarSongs = 1.0;
        public double twoStarSongs = 0.0;
        static WorldVariables clientSide = new WorldVariables();

        public static WorldVariables load(CompoundTag tag) {
            WorldVariables data = new WorldVariables();
            data.read(tag);
            return data;
        }

        public void read(CompoundTag nbt) {
            this.fiveStarSongs = nbt.m_128459_("fiveStarSongs");
            this.fourStarSongs = nbt.m_128459_("fourStarSongs");
            this.oneStarSongs = nbt.m_128459_("oneStarSongs");
            this.otherSongs = nbt.m_128459_("otherSongs");
            this.sevenStarSongs = nbt.m_128459_("sevenStarSongs");
            this.sixStarSongs = nbt.m_128459_("sixStarSongs");
            this.threeStarSongs = nbt.m_128459_("threeStarSongs");
            this.twoStarSongs = nbt.m_128459_("twoStarSongs");
        }

        public CompoundTag m_7176_(CompoundTag nbt) {
            nbt.m_128347_("fiveStarSongs", this.fiveStarSongs);
            nbt.m_128347_("fourStarSongs", this.fourStarSongs);
            nbt.m_128347_("oneStarSongs", this.oneStarSongs);
            nbt.m_128347_("otherSongs", this.otherSongs);
            nbt.m_128347_("sevenStarSongs", this.sevenStarSongs);
            nbt.m_128347_("sixStarSongs", this.sixStarSongs);
            nbt.m_128347_("threeStarSongs", this.threeStarSongs);
            nbt.m_128347_("twoStarSongs", this.twoStarSongs);
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            Level level;
            this.m_77762_();
            if (world instanceof Level && !(level = (Level)world).m_5776_()) {
                MusicDiscExpansionMod.PACKET_HANDLER.send(PacketDistributor.DIMENSION.with(() -> ((Level)level).m_46472_()), (Object)new SavedDataSyncMessage(1, this));
            }
        }

        public static WorldVariables get(LevelAccessor world) {
            if (world instanceof ServerLevel) {
                ServerLevel level = (ServerLevel)world;
                return (WorldVariables)level.m_8895_().m_164861_(e -> WorldVariables.load(e), WorldVariables::new, DATA_NAME);
            }
            return clientSide;
        }
    }

    @Mod.EventBusSubscriber
    public static class EventBusVariableHandlers {
        @SubscribeEvent
        public static void onPlayerLoggedInSyncPlayerVariables(PlayerEvent.PlayerLoggedInEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerRespawnedSyncPlayerVariables(PlayerEvent.PlayerRespawnEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimensionSyncPlayerVariables(PlayerEvent.PlayerChangedDimensionEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void clonePlayer(PlayerEvent.Clone event) {
            event.getOriginal().revive();
            PlayerVariables original = (PlayerVariables)event.getOriginal().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            PlayerVariables clone = (PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            clone.audioLatency = original.audioLatency;
            clone.gamemodeSaved = original.gamemodeSaved;
            clone.mmr = original.mmr;
            clone.musicPercent = original.musicPercent;
            clone.musicScore = original.musicScore;
            clone.musicScoreMult = original.musicScoreMult;
            clone.statNotesHit = original.statNotesHit;
            clone.tutorialCompletion = original.tutorialCompletion;
            clone.xpStored = original.xpStored;
            clone.statGoldStars = original.statGoldStars;
            clone.statDiamondStars = original.statDiamondStars;
            clone.statScore = original.statScore;
            clone.statSongsPlayed = original.statSongsPlayed;
            if (!event.isWasDeath()) {
                clone.songID = original.songID;
            }
        }

        @SubscribeEvent
        public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                MapVariables mapdata = MapVariables.get((LevelAccessor)event.getEntity().m_9236_());
                WorldVariables worlddata = WorldVariables.get((LevelAccessor)event.getEntity().m_9236_());
                if (mapdata != null) {
                    MusicDiscExpansionMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(0, mapdata));
                }
                if (worlddata != null) {
                    MusicDiscExpansionMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(1, worlddata));
                }
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
            WorldVariables worlddata;
            if (!event.getEntity().m_9236_().m_5776_() && (worlddata = WorldVariables.get((LevelAccessor)event.getEntity().m_9236_())) != null) {
                MusicDiscExpansionMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(1, worlddata));
            }
        }
    }
}

