/*
 * Decompiled with CFR 0.152.
 */
package net.xolt.freecam.util;

import com.mojang.authlib.GameProfile;
import java.util.Collections;
import java.util.UUID;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.multiplayer.CommonListenerCookie;
import net.minecraft.client.multiplayer.LevelLoadTracker;
import net.minecraft.client.player.KeyboardInput;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.server.ServerLinks;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Input;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.PushReaction;
import net.xolt.freecam.Freecam;
import net.xolt.freecam.config.ModConfig;
import net.xolt.freecam.util.FreecamPosition;
import net.xolt.freecam.util.Motion;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
@ApiStatus.AvailableSince(value="0.4.0")
public class FreeCamera
extends LocalPlayer {
    private static final ClientPacketListener NETWORK_HANDLER = new ClientPacketListener(Freecam.MC, new Connection(PacketFlow.CLIENTBOUND), new CommonListenerCookie(new LevelLoadTracker(), new GameProfile(UUID.randomUUID(), "FreeCamera"), Freecam.MC.getTelemetryManager().createWorldSessionManager(false, null, null), Freecam.MC.player.registryAccess().freeze(), FeatureFlagSet.of(), null, null, null, Collections.emptyMap(), null, Collections.emptyMap(), ServerLinks.EMPTY, Collections.emptyMap(), false)){

        public void send(Packet<?> packet) {
        }
    };

    public FreeCamera(int id) {
        super(Freecam.MC, Freecam.MC.level, NETWORK_HANDLER, Freecam.MC.player.getStats(), Freecam.MC.player.getRecipeBook(), Input.EMPTY, false);
        this.setId(id);
        this.setPose(Pose.SWIMMING);
        this.setClientLoaded(true);
        this.getAbilities().flying = true;
        this.input = new KeyboardInput(Freecam.MC.options);
    }

    public void copyPosition(Entity entity) {
        this.applyPosition(new FreecamPosition(entity));
    }

    public void applyPosition(FreecamPosition position) {
        this.snapTo(position.x, position.y, position.z, position.yaw, position.pitch);
        this.xBob = this.getXRot();
        this.yBob = this.getYRot();
        this.xBobO = this.xBob;
        this.yBobO = this.yBob;
    }

    public void applyPerspective(ModConfig.Perspective perspective, boolean checkCollision) {
        FreecamPosition position = new FreecamPosition((Entity)this);
        switch (perspective) {
            case INSIDE: {
                break;
            }
            case FIRST_PERSON: {
                this.moveForwardUntilCollision(position, 0.4, checkCollision);
                break;
            }
            case THIRD_PERSON_MIRROR: {
                position.mirrorRotation();
            }
            case THIRD_PERSON: {
                this.moveForwardUntilCollision(position, -4.0, checkCollision);
            }
        }
    }

    private boolean moveForwardUntilCollision(FreecamPosition position, double distance, boolean checkCollision) {
        if (!checkCollision) {
            position.moveForward(distance);
            this.applyPosition(position);
            return true;
        }
        return this.moveForwardUntilCollision(position, distance);
    }

    private boolean moveForwardUntilCollision(FreecamPosition position, double maxDistance) {
        boolean negative = maxDistance < 0.0;
        maxDistance = negative ? -1.0 * maxDistance : maxDistance;
        double increment = 0.1;
        for (double distance = 0.0; distance < maxDistance; distance += increment) {
            FreecamPosition oldPosition = new FreecamPosition((Entity)this);
            position.moveForward(negative ? -1.0 * increment : increment);
            this.applyPosition(position);
            if (this.wouldNotSuffocateAtTargetPose(this.getPose())) continue;
            this.applyPosition(oldPosition);
            return distance > 0.0;
        }
        return true;
    }

    public void spawn() {
        ((ClientLevel)this.level()).addEntity((Entity)this);
    }

    public void despawn() {
        ((ClientLevel)this.level()).removeEntity(this.getId(), Entity.RemovalReason.DISCARDED);
    }

    protected void checkFallDamage(double heightDifference, boolean onGround, BlockState landedState, BlockPos landedPosition) {
    }

    public float getAttackAnim(float tickDelta) {
        return Freecam.MC.player.getAttackAnim(tickDelta);
    }

    public int getUseItemRemainingTicks() {
        return Freecam.MC.player.getUseItemRemainingTicks();
    }

    public boolean isUsingItem() {
        return Freecam.MC.player.isUsingItem();
    }

    public boolean onClimbable() {
        return false;
    }

    public boolean isInWater() {
        return false;
    }

    public MobEffectInstance getEffect(Holder<MobEffect> holder) {
        return Freecam.MC.player.getEffect(holder);
    }

    public PushReaction getPistonPushReaction() {
        return ModConfig.INSTANCE.collision.ignoreAll ? PushReaction.IGNORE : PushReaction.NORMAL;
    }

    public boolean canCollideWith(Entity other) {
        return false;
    }

    public void setPose(Pose pose) {
        super.setPose(Pose.SWIMMING);
    }

    public boolean isMovingSlowly() {
        return false;
    }

    protected boolean updateIsUnderwater() {
        this.wasUnderwater = this.isEyeInFluid(FluidTags.WATER);
        return this.wasUnderwater;
    }

    protected void doWaterSplashEffect() {
    }

    public void aiStep() {
        if (ModConfig.INSTANCE.movement.flightMode.equals((Object)ModConfig.FlightMode.DEFAULT)) {
            this.getAbilities().setFlyingSpeed(0.0f);
            Motion.doMotion(this, ModConfig.INSTANCE.movement.horizontalSpeed, ModConfig.INSTANCE.movement.verticalSpeed);
        } else {
            this.getAbilities().setFlyingSpeed((float)ModConfig.INSTANCE.movement.verticalSpeed / 10.0f);
        }
        super.aiStep();
        this.getAbilities().flying = true;
        this.setOnGround(false);
    }
}

