/*
 * Decompiled with CFR 0.152.
 */
package net.xolt.freecam.mixins;

import net.minecraft.world.entity.Entity;
import net.xolt.freecam.Freecam;
import net.xolt.freecam.config.ModConfig;
import net.xolt.freecam.variant.api.BuildVariant;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Entity.class})
public class EntityMixin {
    @Inject(method={"turn"}, at={@At(value="HEAD")}, cancellable=true)
    private void onChangeLookDirection(double rotation, double pitch, CallbackInfo ci) {
        if (Freecam.isEnabled() && this.equals(Freecam.MC.f_91074_) && !Freecam.isPlayerControlEnabled()) {
            Freecam.getFreeCamera().m_19884_(rotation, pitch);
            ci.cancel();
        }
    }

    @Inject(method={"push(Lnet/minecraft/world/entity/Entity;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void onPushAwayFrom(Entity entity, CallbackInfo ci) {
        if (Freecam.isEnabled() && (entity.equals((Object)Freecam.getFreeCamera()) || this.equals((Object)Freecam.getFreeCamera()))) {
            ci.cancel();
        }
    }

    @Inject(method={"setDeltaMovement(DDD)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void onSetVelocity(CallbackInfo ci) {
        if (this.freecam$shouldFreeze()) {
            ci.cancel();
        }
    }

    @Inject(method={"moveRelative"}, at={@At(value="HEAD")}, cancellable=true)
    private void onUpdateVelocity(CallbackInfo ci) {
        if (this.freecam$shouldFreeze()) {
            ci.cancel();
        }
    }

    @Inject(method={"setPos(DDD)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void onSetPosition(CallbackInfo ci) {
        if (this.freecam$shouldFreeze()) {
            ci.cancel();
        }
    }

    @Inject(method={"setPosRaw"}, at={@At(value="HEAD")}, cancellable=true)
    private void onSetPos(CallbackInfo ci) {
        if (this.freecam$shouldFreeze()) {
            ci.cancel();
        }
    }

    @Unique
    private boolean freecam$shouldFreeze() {
        return Freecam.isEnabled() && this.equals(Freecam.MC.f_91074_) && this.freecam$allowFreeze();
    }

    @Unique
    private boolean freecam$allowFreeze() {
        return ModConfig.INSTANCE.utility.freezePlayer && BuildVariant.getInstance().cheatsPermitted() && !Freecam.isPlayerControlEnabled();
    }
}

