/*
 * Decompiled with CFR 0.152.
 */
package net.xolt.freecam.mixins;

import net.minecraft.client.Minecraft;
import net.xolt.freecam.Freecam;
import net.xolt.freecam.config.ModBindings;
import net.xolt.freecam.config.ModConfig;
import net.xolt.freecam.variant.api.BuildVariant;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Minecraft.class})
public class MinecraftMixin {
    @Inject(method={"startAttack"}, at={@At(value="HEAD")}, cancellable=true)
    private void onDoAttack(CallbackInfoReturnable<Boolean> cir) {
        if (MinecraftMixin.freecam$disableInteract()) {
            cir.cancel();
        }
    }

    @Inject(method={"pickBlock"}, at={@At(value="HEAD")}, cancellable=true)
    private void onDoItemPick(CallbackInfo ci) {
        if (MinecraftMixin.freecam$disableInteract()) {
            ci.cancel();
        }
    }

    @Inject(method={"continueAttack"}, at={@At(value="HEAD")}, cancellable=true)
    private void onHandleBlockBreaking(CallbackInfo ci) {
        if (MinecraftMixin.freecam$disableInteract()) {
            ci.cancel();
        }
    }

    @Inject(method={"handleKeybinds"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/KeyMapping;consumeClick()Z", ordinal=2)}, cancellable=true)
    private void onHandleInputEvents(CallbackInfo ci) {
        if (ModBindings.KEY_TOGGLE.get().m_90857_() || ModBindings.KEY_TRIPOD_RESET.get().m_90857_()) {
            ci.cancel();
        }
    }

    @Inject(method={"clearLevel()V"}, at={@At(value="HEAD")})
    private void onDisconnect(CallbackInfo ci) {
        Freecam.onDisconnect();
    }

    @Unique
    private static boolean freecam$disableInteract() {
        return Freecam.isEnabled() && !Freecam.isPlayerControlEnabled() && !MinecraftMixin.freecam$allowInteract();
    }

    @Unique
    private static boolean freecam$allowInteract() {
        return ModConfig.INSTANCE.utility.allowInteract && (BuildVariant.getInstance().cheatsPermitted() || ModConfig.INSTANCE.utility.interactionMode.equals((Object)ModConfig.InteractionMode.PLAYER));
    }
}

