/*
 * Decompiled with CFR 0.152.
 */
package net.xolt.freecam.util;

import com.mojang.authlib.GameProfile;
import java.util.UUID;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.player.KeyboardInput;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.PushReaction;
import net.xolt.freecam.Freecam;
import net.xolt.freecam.config.ModConfig;
import net.xolt.freecam.util.FreecamPosition;
import net.xolt.freecam.util.Motion;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
@ApiStatus.AvailableSince(value="0.4.0")
public class FreeCamera
extends LocalPlayer {
    private static final ClientPacketListener NETWORK_HANDLER = new ClientPacketListener(Freecam.MC, Freecam.MC.f_91080_, new Connection(PacketFlow.CLIENTBOUND), null, new GameProfile(UUID.randomUUID(), "FreeCamera"), Freecam.MC.m_261007_().m_260825_(false, null)){

        public void m_104955_(Packet<?> packet) {
        }
    };

    public FreeCamera(int id) {
        super(Freecam.MC, Freecam.MC.f_91073_, NETWORK_HANDLER, Freecam.MC.f_91074_.m_108630_(), Freecam.MC.f_91074_.m_108631_(), false, false);
        this.m_20234_(id);
        this.m_20124_(Pose.SWIMMING);
        this.m_150110_().f_35935_ = true;
        this.f_108618_ = new KeyboardInput(Freecam.MC.f_91066_);
    }

    public void m_20359_(Entity entity) {
        this.applyPosition(new FreecamPosition(entity));
    }

    public void applyPosition(FreecamPosition position) {
        this.m_7678_(position.x, position.y, position.z, position.yaw, position.pitch);
        this.f_108586_ = this.m_146909_();
        this.f_108585_ = this.m_146908_();
        this.f_108588_ = this.f_108586_;
        this.f_108587_ = this.f_108585_;
    }

    public void applyPerspective(ModConfig.Perspective perspective, boolean checkCollision) {
        FreecamPosition position = new FreecamPosition((Entity)this);
        switch (perspective) {
            case INSIDE: {
                break;
            }
            case FIRST_PERSON: {
                this.moveForwardUntilCollision(position, 0.4, checkCollision);
                break;
            }
            case THIRD_PERSON_MIRROR: {
                position.mirrorRotation();
            }
            case THIRD_PERSON: {
                this.moveForwardUntilCollision(position, -4.0, checkCollision);
            }
        }
    }

    private boolean moveForwardUntilCollision(FreecamPosition position, double distance, boolean checkCollision) {
        if (!checkCollision) {
            position.moveForward(distance);
            this.applyPosition(position);
            return true;
        }
        return this.moveForwardUntilCollision(position, distance);
    }

    private boolean moveForwardUntilCollision(FreecamPosition position, double maxDistance) {
        boolean negative = maxDistance < 0.0;
        maxDistance = negative ? -1.0 * maxDistance : maxDistance;
        double increment = 0.1;
        for (double distance = 0.0; distance < maxDistance; distance += increment) {
            FreecamPosition oldPosition = new FreecamPosition((Entity)this);
            position.moveForward(negative ? -1.0 * increment : increment);
            this.applyPosition(position);
            if (this.m_20175_(this.m_20089_())) continue;
            this.applyPosition(oldPosition);
            return distance > 0.0;
        }
        return true;
    }

    public void spawn() {
        this.f_108545_.m_104627_(this.m_19879_(), (Entity)this);
    }

    public void despawn() {
        this.f_108545_.m_171642_(this.m_19879_(), Entity.RemovalReason.DISCARDED);
    }

    protected void m_7840_(double heightDifference, boolean onGround, BlockState landedState, BlockPos landedPosition) {
    }

    public float m_21324_(float tickDelta) {
        return Freecam.MC.f_91074_.m_21324_(tickDelta);
    }

    public int m_21212_() {
        return Freecam.MC.f_91074_.m_21212_();
    }

    public boolean m_6117_() {
        return Freecam.MC.f_91074_.m_6117_();
    }

    public boolean m_6147_() {
        return false;
    }

    public boolean m_20069_() {
        return false;
    }

    public MobEffectInstance m_21124_(MobEffect effect) {
        return Freecam.MC.f_91074_.m_21124_(effect);
    }

    public PushReaction m_7752_() {
        return ModConfig.INSTANCE.collision.ignoreAll ? PushReaction.IGNORE : PushReaction.NORMAL;
    }

    public boolean m_7337_(Entity other) {
        return false;
    }

    public void m_20124_(Pose pose) {
        super.m_20124_(Pose.SWIMMING);
    }

    public boolean m_108635_() {
        return false;
    }

    protected boolean m_7602_() {
        this.f_36076_ = this.m_204029_(FluidTags.f_13131_);
        return this.f_36076_;
    }

    protected void m_5841_() {
    }

    public void m_8107_() {
        if (ModConfig.INSTANCE.movement.flightMode.equals((Object)ModConfig.FlightMode.DEFAULT)) {
            this.m_150110_().m_35943_(0.0f);
            Motion.doMotion(this, ModConfig.INSTANCE.movement.horizontalSpeed, ModConfig.INSTANCE.movement.verticalSpeed);
        } else {
            this.m_150110_().m_35943_((float)ModConfig.INSTANCE.movement.verticalSpeed / 10.0f);
        }
        super.m_8107_();
        this.m_150110_().f_35935_ = true;
        this.m_6853_(false);
    }
}

