/*
 * Decompiled with CFR 0.152.
 */
package net.xolt.freecam.config;

import java.util.ArrayList;
import java.util.List;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.ConfigData;
import me.shedaniel.autoconfig.ConfigHolder;
import me.shedaniel.autoconfig.annotation.Config;
import me.shedaniel.autoconfig.annotation.ConfigEntry;
import me.shedaniel.autoconfig.serializer.JanksonConfigSerializer;
import me.shedaniel.clothconfig2.gui.entries.SelectionListEntry;
import net.xolt.freecam.config.CollisionBehavior;
import net.xolt.freecam.config.gui.AutoConfigExtensions;
import net.xolt.freecam.config.gui.BoundedContinuous;
import net.xolt.freecam.config.gui.ModBindingsConfig;
import net.xolt.freecam.config.gui.ValidateRegex;
import net.xolt.freecam.config.gui.VariantTooltip;
import net.xolt.freecam.variant.api.BuildVariant;
import org.jetbrains.annotations.NotNull;

@Config(name="freecam")
public class ModConfig
implements ConfigData {
    @ConfigEntry.Gui.Excluded
    public static ModConfig INSTANCE;
    @ConfigEntry.Gui.Tooltip
    @ConfigEntry.Gui.CollapsibleObject
    public ControlsConfig controls = new ControlsConfig();
    @ConfigEntry.Gui.Tooltip
    @ConfigEntry.Gui.CollapsibleObject
    public MovementConfig movement = new MovementConfig();
    @ConfigEntry.Gui.Tooltip
    @ConfigEntry.Gui.CollapsibleObject
    public CollisionConfig collision = new CollisionConfig();
    @ConfigEntry.Gui.Tooltip
    @ConfigEntry.Gui.CollapsibleObject
    public VisualConfig visual = new VisualConfig();
    @ConfigEntry.Gui.Tooltip
    @ConfigEntry.Gui.CollapsibleObject
    public UtilityConfig utility = new UtilityConfig();
    @ConfigEntry.Gui.Tooltip
    @ConfigEntry.Gui.CollapsibleObject
    public ServerConfig servers = new ServerConfig();
    @ConfigEntry.Gui.Tooltip
    @ConfigEntry.Gui.CollapsibleObject
    public NotificationConfig notification = new NotificationConfig();

    public static void init() {
        ConfigHolder holder = AutoConfig.register(ModConfig.class, JanksonConfigSerializer::new);
        AutoConfigExtensions.apply(ModConfig.class);
        holder.registerSaveListener(CollisionBehavior::onConfigChange);
        holder.registerLoadListener(CollisionBehavior::onConfigChange);
        INSTANCE = (ModConfig)holder.getConfig();
        CollisionBehavior.onConfigChange((ConfigHolder<ModConfig>)holder, INSTANCE);
    }

    public static class ControlsConfig {
        @ModBindingsConfig
        private Object keys;
    }

    public static class MovementConfig {
        @ConfigEntry.Gui.Tooltip
        @ConfigEntry.Gui.EnumHandler(option=ConfigEntry.Gui.EnumHandler.EnumDisplayOption.BUTTON)
        public FlightMode flightMode = FlightMode.DEFAULT;
        @ConfigEntry.Gui.Tooltip
        @BoundedContinuous(max=10.0)
        public double horizontalSpeed = 1.0;
        @ConfigEntry.Gui.Tooltip
        @BoundedContinuous(max=10.0)
        public double verticalSpeed = 1.0;
    }

    public static class CollisionConfig {
        @ConfigEntry.Gui.Tooltip
        public boolean ignoreTransparent = false;
        @ConfigEntry.Gui.Tooltip
        public boolean ignoreOpenable = false;
        @VariantTooltip.List(value={@VariantTooltip(variant="normal", count=1), @VariantTooltip(variant="modrinth", count=2)})
        public boolean ignoreCustom = false;
        @ConfigEntry.Gui.TransitiveObject
        public CollisionWhitelist whitelist = new CollisionWhitelist();
        @VariantTooltip.List(value={@VariantTooltip(variant="normal", count=2), @VariantTooltip(variant="modrinth", count=3)})
        public boolean ignoreAll = !BuildVariant.getInstance().name().equals("modrinth");
        @ConfigEntry.Gui.Tooltip(count=2)
        public boolean alwaysCheck = false;

        public static class CollisionWhitelist {
            @ConfigEntry.Gui.Tooltip(count=2)
            public List<String> ids = new ArrayList<String>();
            @ValidateRegex
            @ConfigEntry.Gui.Tooltip(count=2)
            public List<String> patterns = new ArrayList<String>();
        }
    }

    public static class VisualConfig {
        @ConfigEntry.Gui.Tooltip
        @ConfigEntry.Gui.EnumHandler(option=ConfigEntry.Gui.EnumHandler.EnumDisplayOption.BUTTON)
        public Perspective perspective = Perspective.INSIDE;
        @ConfigEntry.Gui.Tooltip
        public boolean showPlayer = true;
        @ConfigEntry.Gui.Tooltip
        public boolean showHand = false;
        @ConfigEntry.Gui.Tooltip
        public boolean fullBright = false;
        @ConfigEntry.Gui.Tooltip
        public boolean showSubmersion = false;
    }

    public static class UtilityConfig {
        @ConfigEntry.Gui.Tooltip
        public boolean disableOnDamage = true;
        @VariantTooltip(count=2)
        public boolean freezePlayer = false;
        @VariantTooltip.List(value={@VariantTooltip(variant="normal", count=2), @VariantTooltip(variant="modrinth", count=3)})
        public boolean allowInteract = false;
        @ConfigEntry.Gui.Tooltip
        @ConfigEntry.Gui.EnumHandler(option=ConfigEntry.Gui.EnumHandler.EnumDisplayOption.BUTTON)
        public InteractionMode interactionMode = InteractionMode.CAMERA;
    }

    public static class ServerConfig {
        @ConfigEntry.Gui.Tooltip(count=2)
        @ConfigEntry.Gui.EnumHandler(option=ConfigEntry.Gui.EnumHandler.EnumDisplayOption.BUTTON)
        public ServerRestriction mode = ServerRestriction.NONE;
        public List<String> whitelist = new ArrayList<String>();
        public List<String> blacklist = new ArrayList<String>();
    }

    public static class NotificationConfig {
        @ConfigEntry.Gui.Tooltip
        public boolean notifyFreecam = true;
        @ConfigEntry.Gui.Tooltip
        public boolean notifyTripod = true;
    }

    public static enum ServerRestriction implements SelectionListEntry.Translatable
    {
        NONE,
        WHITELIST,
        BLACKLIST;


        @NotNull
        public String getKey() {
            return "text.autoconfig.freecam.option.servers.mode." + this.toString().toLowerCase();
        }
    }

    public static enum Perspective implements SelectionListEntry.Translatable
    {
        FIRST_PERSON("firstPerson"),
        THIRD_PERSON("thirdPerson"),
        THIRD_PERSON_MIRROR("thirdPersonMirror"),
        INSIDE("inside");

        private final String key;

        private Perspective(String name) {
            this.key = "text.autoconfig.freecam.option.visual.perspective." + name;
        }

        @NotNull
        public String getKey() {
            return this.key;
        }
    }

    public static enum InteractionMode implements SelectionListEntry.Translatable
    {
        CAMERA("camera"),
        PLAYER("player");

        private final String key;

        private InteractionMode(String name) {
            this.key = "text.autoconfig.freecam.option.utility.interactionMode." + name;
        }

        @NotNull
        public String getKey() {
            return this.key;
        }
    }

    public static enum FlightMode implements SelectionListEntry.Translatable
    {
        CREATIVE("creative"),
        DEFAULT("default");

        private final String key;

        private FlightMode(String name) {
            this.key = "text.autoconfig.freecam.option.movement.flightMode." + name;
        }

        @NotNull
        public String getKey() {
            return this.key;
        }
    }
}

