/*
 * Decompiled with CFR 0.152.
 */
package net.xolt.freecam.config.gui;

import com.google.common.util.concurrent.AtomicDouble;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.vertex.PoseStack;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import me.shedaniel.clothconfig2.gui.entries.TooltipListEntry;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.AbstractSliderButton;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.xolt.freecam.Freecam;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class DoubleSliderEntry
extends TooltipListEntry<Double> {
    private final Slider sliderWidget;
    private final Button resetButton;
    private final AtomicDouble value;
    private final double original;
    private final int precision;
    private final double minimum;
    private final double maximum;
    private final Consumer<Double> saveCallback;
    private final Supplier<Double> defaultValue;
    private final List<AbstractWidget> widgets;

    DoubleSliderEntry(Component fieldName, int precision, double minimum, double maximum, double value, Component resetText, Supplier<Double> defaultValue, @Nullable Consumer<Double> save) {
        super(fieldName, null);
        this.value = new AtomicDouble(value);
        this.original = value;
        this.defaultValue = defaultValue;
        this.maximum = maximum;
        this.minimum = minimum;
        this.precision = precision;
        this.saveCallback = save;
        this.sliderWidget = new Slider(0, 0, 152, 20, (this.value.get() - minimum) / (maximum - minimum));
        this.sliderWidget.m_5695_();
        this.resetButton = new Button(0, 0, Freecam.MC.f_91062_.m_92852_((FormattedText)resetText) + 6, 20, resetText, widget -> this.setValue(this.defaultValue.get()));
        this.widgets = List.of(this.sliderWidget, this.resetButton);
    }

    public Double getValue() {
        return this.value.get();
    }

    public void setValue(double value) {
        double clamped = Mth.m_14008_((double)value, (double)this.minimum, (double)this.maximum);
        this.value.set(clamped);
        this.sliderWidget.setValue((clamped - this.minimum) / (this.maximum - this.minimum));
        this.sliderWidget.m_5695_();
    }

    public boolean isEdited() {
        return super.isEdited() || this.getValue() != this.original;
    }

    public Optional<Double> getDefaultValue() {
        return Optional.ofNullable(this.defaultValue).map(Supplier::get);
    }

    public void save() {
        if (this.saveCallback != null) {
            this.saveCallback.accept(this.getValue());
        }
    }

    @NotNull
    public List<? extends GuiEventListener> m_6702_() {
        return this.widgets;
    }

    public List<? extends NarratableEntry> narratables() {
        return this.widgets;
    }

    public void render(PoseStack matrices, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isHovered, float delta) {
        super.render(matrices, index, y, x, entryWidth, entryHeight, mouseX, mouseY, isHovered, delta);
        Window window = Freecam.MC.m_91268_();
        this.resetButton.f_93623_ = this.isEditable() && this.getDefaultValue().isPresent() && this.defaultValue.get().doubleValue() != this.value.get();
        this.resetButton.f_93621_ = y;
        this.sliderWidget.f_93623_ = this.isEditable();
        this.sliderWidget.f_93621_ = y;
        Component name = this.getDisplayedFieldName();
        if (Freecam.MC.f_91062_.m_92718_()) {
            DoubleSliderEntry.m_168756_((PoseStack)matrices, (Font)Freecam.MC.f_91062_, (FormattedCharSequence)name.m_7532_(), (int)(window.m_85445_() - x - Freecam.MC.f_91062_.m_92852_((FormattedText)name)), (int)(y + 6), (int)this.getPreferredTextColor());
            this.resetButton.f_93620_ = x;
            this.sliderWidget.f_93620_ = x + this.resetButton.m_5711_() + 1;
        } else {
            DoubleSliderEntry.m_168756_((PoseStack)matrices, (Font)Freecam.MC.f_91062_, (FormattedCharSequence)name.m_7532_(), (int)x, (int)(y + 6), (int)this.getPreferredTextColor());
            this.resetButton.f_93620_ = x + entryWidth - this.resetButton.m_5711_();
            this.sliderWidget.f_93620_ = x + entryWidth - 150;
        }
        this.sliderWidget.m_93674_(150 - this.resetButton.m_5711_() - 2);
        this.resetButton.m_6305_(matrices, mouseX, mouseY, delta);
        this.sliderWidget.m_6305_(matrices, mouseX, mouseY, delta);
    }

    private final class Slider
    extends AbstractSliderButton {
        private Slider(int x, int y, int width, int height, double value) {
            super(x, y, width, height, TextComponent.f_131282_, value);
        }

        public void m_5695_() {
            NumberFormat fmt = DecimalFormat.getInstance();
            fmt.setMinimumIntegerDigits(1);
            fmt.setMinimumFractionDigits(DoubleSliderEntry.this.precision);
            fmt.setMaximumFractionDigits(DoubleSliderEntry.this.precision);
            this.m_93666_((Component)new TextComponent("Value: " + fmt.format(DoubleSliderEntry.this.value.get())));
        }

        protected void m_5697_() {
            double rounded = BigDecimal.valueOf(DoubleSliderEntry.this.minimum + (DoubleSliderEntry.this.maximum - DoubleSliderEntry.this.minimum) * this.f_93577_).setScale(DoubleSliderEntry.this.precision, RoundingMode.HALF_UP).doubleValue();
            DoubleSliderEntry.this.value.set(rounded);
        }

        public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
            return DoubleSliderEntry.this.isEditable() && super.m_7933_(keyCode, scanCode, modifiers);
        }

        public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
            return DoubleSliderEntry.this.isEditable() && super.m_7979_(mouseX, mouseY, button, dragX, dragY);
        }

        public void setValue(double value) {
            this.f_93577_ = value;
        }
    }
}

