/*
 * Decompiled with CFR 0.152.
 */
package net.xolt.freecam.config.keys;

import com.mojang.blaze3d.platform.InputConstants;
import net.xolt.freecam.config.keys.FreecamComboKeyMapping;
import net.xolt.freecam.config.keys.FreecamKeyMapping;
import net.xolt.freecam.config.keys.HoldAction;

public class FreecamKeyMappingBuilder {
    private final String translationKey;
    private InputConstants.Type type = InputConstants.Type.KEYSYM;
    private int keyCode = -1;
    private Runnable action;
    private HoldAction holdAction;
    private long maxTicks = 10L;

    private FreecamKeyMappingBuilder(String translationKey) {
        this.translationKey = translationKey;
    }

    public static FreecamKeyMappingBuilder builder(String translationKey) {
        return new FreecamKeyMappingBuilder(translationKey);
    }

    public FreecamKeyMappingBuilder type(InputConstants.Type type) {
        this.type = type;
        return this;
    }

    public FreecamKeyMappingBuilder maxHoldTicks(long ticks) {
        this.maxTicks = ticks;
        return this;
    }

    public FreecamKeyMappingBuilder defaultKey(int keyCode) {
        this.keyCode = keyCode;
        return this;
    }

    public FreecamKeyMappingBuilder action(Runnable action) {
        this.action = action;
        return this;
    }

    public FreecamKeyMappingBuilder holdAction(HoldAction action) {
        this.holdAction = action;
        return this;
    }

    public FreecamKeyMapping build() {
        if (this.action != null && this.holdAction != null) {
            return new FreecamComboKeyMapping(this.translationKey, this.type, this.keyCode, this.action, this.holdAction, this.maxTicks);
        }
        if (this.action != null) {
            return new FreecamKeyMapping(this.translationKey, this.type, this.keyCode, self -> {
                while (self.m_90859_()) {
                    this.action.run();
                }
            });
        }
        if (this.holdAction != null) {
            return new FreecamKeyMapping(this.translationKey, this.type, this.keyCode, self -> {
                if (self.m_90857_()) {
                    this.holdAction.run();
                }
            });
        }
        throw new IllegalStateException("No action defined.");
    }
}

