/*
 * Decompiled with CFR 0.152.
 */
package net.xolt.freecam;

import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.client.renderer.texture.ITickable;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.settings.PointOfView;
import net.minecraft.entity.Entity;
import net.minecraft.util.MovementInput;
import net.minecraft.util.MovementInputFromOptions;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.xolt.freecam.config.ModBindings;
import net.xolt.freecam.config.ModConfig;
import net.xolt.freecam.tripod.TripodRegistry;
import net.xolt.freecam.tripod.TripodSlot;
import net.xolt.freecam.util.FreeCamera;
import net.xolt.freecam.util.FreecamPosition;
import net.xolt.freecam.variant.api.BuildVariant;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public class Freecam {
    public static final Minecraft MC = Minecraft.func_71410_x();
    public static final String MOD_ID = "freecam";
    private static boolean freecamEnabled = false;
    private static boolean tripodEnabled = false;
    private static boolean playerControlEnabled = false;
    private static boolean disableNextTick = false;
    private static final TripodRegistry tripods = new TripodRegistry();
    private static TripodSlot activeTripod = TripodSlot.NONE;
    private static FreeCamera freeCamera;
    private static PointOfView rememberedF5;

    @ApiStatus.Internal
    public static void preTick(Minecraft mc) {
        if ((disableNextTick || Freecam.isRestrictedOnServer()) && Freecam.isEnabled()) {
            Freecam.toggle();
        }
        disableNextTick = false;
        if (Freecam.isEnabled()) {
            if (mc.field_71439_g != null && mc.field_71439_g.field_71158_b instanceof MovementInputFromOptions && !Freecam.isPlayerControlEnabled()) {
                MovementInput input = new MovementInput();
                input.field_228350_h_ = mc.field_71439_g.field_71158_b.field_228350_h_;
                mc.field_71439_g.field_71158_b = input;
            }
            mc.field_71460_t.field_175074_C = ModConfig.INSTANCE.visual.showHand;
        }
    }

    @ApiStatus.Internal
    public static void postTick(Minecraft mc) {
        ModBindings.forEach(ITickable::func_110550_d);
    }

    @ApiStatus.Internal
    public static void onDisconnect() {
        if (Freecam.isEnabled()) {
            Freecam.toggle();
        }
        tripods.clear();
    }

    @ApiStatus.Internal
    public static boolean activateTripodHandler() {
        boolean activated = false;
        for (KeyBinding combo : Freecam.MC.field_71474_y.field_151456_ac) {
            while (combo.func_151468_f()) {
                Freecam.toggleTripod(TripodSlot.ofKeyCode(combo.func_197977_i().func_197937_c()));
                activated = true;
            }
        }
        return activated;
    }

    @ApiStatus.Internal
    public static boolean resetTripodHandler() {
        boolean reset = false;
        for (KeyBinding key : Freecam.MC.field_71474_y.field_151456_ac) {
            while (key.func_151468_f()) {
                Freecam.resetCamera(TripodSlot.ofKeyCode(key.func_197977_i().func_197937_c()));
                reset = true;
            }
        }
        return reset;
    }

    @ApiStatus.AvailableSince(value="0.3.1")
    public static void toggle() {
        if (Freecam.isRestrictedOnServer()) {
            if (ModConfig.INSTANCE.notification.notifyFreecam) {
                Freecam.MC.field_71439_g.func_146105_b((ITextComponent)new TranslationTextComponent("msg.freecam.restrictedByConfig", new Object[]{Freecam.MC.func_147104_D().field_78845_b}), true);
            }
            return;
        }
        if (tripodEnabled) {
            Freecam.toggleTripod(activeTripod);
            return;
        }
        if (freecamEnabled) {
            Freecam.onDisableFreecam();
        } else {
            Freecam.onEnableFreecam();
        }
        boolean bl = freecamEnabled = !freecamEnabled;
        if (!freecamEnabled) {
            Freecam.onDisabled();
        }
    }

    private static void toggleTripod(TripodSlot tripod) {
        if (tripod == TripodSlot.NONE) {
            return;
        }
        if (Freecam.isRestrictedOnServer()) {
            if (ModConfig.INSTANCE.notification.notifyTripod) {
                Freecam.MC.field_71439_g.func_146105_b((ITextComponent)new TranslationTextComponent("msg.freecam.restrictedByConfig", new Object[]{Freecam.MC.func_147104_D().field_78845_b}), true);
            }
            return;
        }
        if (tripodEnabled) {
            if (activeTripod == tripod) {
                Freecam.onDisableTripod();
                tripodEnabled = false;
            } else {
                Freecam.onDisableTripod();
                Freecam.onEnableTripod(tripod);
            }
        } else {
            if (freecamEnabled) {
                Freecam.toggle();
            }
            Freecam.onEnableTripod(tripod);
            tripodEnabled = true;
        }
        if (!tripodEnabled) {
            Freecam.onDisabled();
        }
    }

    @ApiStatus.AvailableSince(value="1.1.8")
    public static void switchControls() {
        if (!Freecam.isEnabled()) {
            return;
        }
        if (playerControlEnabled) {
            Freecam.freeCamera.field_71158_b = new MovementInputFromOptions(Freecam.MC.field_71474_y);
        } else {
            Freecam.MC.field_71439_g.field_71158_b = new MovementInputFromOptions(Freecam.MC.field_71474_y);
            Freecam.freeCamera.field_71158_b = new MovementInput();
        }
        playerControlEnabled = !playerControlEnabled;
    }

    private static void onEnableTripod(TripodSlot tripod) {
        Freecam.onEnable();
        FreecamPosition position = tripods.get(tripod);
        boolean chunkLoaded = false;
        if (position != null) {
            ChunkPos chunkPos = position.getChunkPos();
            chunkLoaded = Freecam.MC.field_71441_e.func_72863_F().func_73149_a(chunkPos.field_77276_a, chunkPos.field_77275_b);
        }
        if (!chunkLoaded) {
            Freecam.resetCamera(tripod);
            position = null;
        }
        freeCamera = new FreeCamera(-420 - tripod.ordinal());
        if (position == null) {
            Freecam.moveToPlayer();
        } else {
            Freecam.moveToPosition(position);
        }
        freeCamera.spawn();
        MC.func_175607_a((Entity)freeCamera);
        activeTripod = tripod;
        if (ModConfig.INSTANCE.notification.notifyTripod) {
            Freecam.MC.field_71439_g.func_146105_b((ITextComponent)new TranslationTextComponent("msg.freecam.openTripod", new Object[]{tripod}), true);
        }
    }

    private static void onDisableTripod() {
        tripods.put(activeTripod, new FreecamPosition((Entity)freeCamera));
        Freecam.onDisable();
        if (Freecam.MC.field_71439_g != null && ModConfig.INSTANCE.notification.notifyTripod) {
            Freecam.MC.field_71439_g.func_146105_b((ITextComponent)new TranslationTextComponent("msg.freecam.closeTripod", new Object[]{activeTripod}), true);
        }
        activeTripod = TripodSlot.NONE;
    }

    private static void onEnableFreecam() {
        Freecam.onEnable();
        freeCamera = new FreeCamera(-420);
        Freecam.moveToPlayer();
        freeCamera.spawn();
        MC.func_175607_a((Entity)freeCamera);
        if (ModConfig.INSTANCE.notification.notifyFreecam) {
            Freecam.MC.field_71439_g.func_146105_b((ITextComponent)new TranslationTextComponent("msg.freecam.enable"), true);
        }
    }

    private static void onDisableFreecam() {
        Freecam.onDisable();
        if (Freecam.MC.field_71439_g != null && ModConfig.INSTANCE.notification.notifyFreecam) {
            Freecam.MC.field_71439_g.func_146105_b((ITextComponent)new TranslationTextComponent("msg.freecam.disable"), true);
        }
    }

    private static void onEnable() {
        Freecam.MC.field_175612_E = false;
        Freecam.MC.field_71460_t.field_175074_C = ModConfig.INSTANCE.visual.showHand;
        rememberedF5 = Freecam.MC.field_71474_y.func_243230_g();
        if (Freecam.MC.field_71460_t.func_215316_n().func_216770_i()) {
            Freecam.MC.field_71474_y.func_243229_a(PointOfView.FIRST_PERSON);
        }
    }

    private static void onDisable() {
        Freecam.MC.field_175612_E = true;
        Freecam.MC.field_71460_t.field_175074_C = true;
        MC.func_175607_a((Entity)Freecam.MC.field_71439_g);
        playerControlEnabled = false;
        freeCamera.despawn();
        Freecam.freeCamera.field_71158_b = new MovementInput();
        freeCamera = null;
        if (Freecam.MC.field_71439_g != null) {
            Freecam.MC.field_71439_g.field_71158_b = new MovementInputFromOptions(Freecam.MC.field_71474_y);
        }
    }

    private static void onDisabled() {
        if (rememberedF5 != null) {
            Freecam.MC.field_71474_y.func_243229_a(rememberedF5);
        }
    }

    private static void resetCamera(TripodSlot tripod) {
        if (tripodEnabled && activeTripod != TripodSlot.NONE && activeTripod == tripod && freeCamera != null) {
            Freecam.moveToPlayer();
        } else {
            tripods.put(tripod, null);
        }
        if (ModConfig.INSTANCE.notification.notifyTripod) {
            Freecam.MC.field_71439_g.func_146105_b((ITextComponent)new TranslationTextComponent("msg.freecam.tripodReset", new Object[]{tripod}), true);
        }
    }

    @ApiStatus.Experimental
    @ApiStatus.AvailableSince(value="1.2.3")
    public static void moveToEntity(@Nullable Entity entity) {
        if (freeCamera == null) {
            return;
        }
        if (entity == null) {
            Freecam.moveToPlayer();
            return;
        }
        freeCamera.func_82149_j(entity);
    }

    @ApiStatus.Experimental
    @ApiStatus.AvailableSince(value="1.2.3")
    public static void moveToPosition(@Nullable FreecamPosition position) {
        if (freeCamera == null) {
            return;
        }
        if (position == null) {
            Freecam.moveToPlayer();
            return;
        }
        freeCamera.applyPosition(position);
    }

    @ApiStatus.Experimental
    @ApiStatus.AvailableSince(value="1.2.3")
    public static void moveToPlayer() {
        if (freeCamera == null) {
            return;
        }
        freeCamera.func_82149_j((Entity)Freecam.MC.field_71439_g);
        freeCamera.applyPerspective(ModConfig.INSTANCE.visual.perspective, ModConfig.INSTANCE.collision.alwaysCheck || !ModConfig.INSTANCE.collision.ignoreAll || !BuildVariant.getInstance().cheatsPermitted());
    }

    @ApiStatus.AvailableSince(value="0.4.0")
    public static FreeCamera getFreeCamera() {
        return freeCamera;
    }

    @ApiStatus.AvailableSince(value="1.2.3")
    public static void disableNextTick() {
        disableNextTick = true;
    }

    @ApiStatus.AvailableSince(value="0.2.2")
    public static boolean isEnabled() {
        return freecamEnabled || tripodEnabled;
    }

    @ApiStatus.Experimental
    @ApiStatus.AvailableSince(value="1.0.0")
    public static boolean isPlayerControlEnabled() {
        return playerControlEnabled;
    }

    @ApiStatus.Experimental
    @ApiStatus.AvailableSince(value="1.2.4")
    public static boolean isRestrictedOnServer() {
        ServerData server = MC.func_147104_D();
        ModConfig.ServerRestriction mode = ModConfig.INSTANCE.servers.mode;
        if (mode == ModConfig.ServerRestriction.NONE || server == null || MC.func_71356_B()) {
            return false;
        }
        String ip = server.field_78845_b.trim().toLowerCase();
        switch (mode) {
            case WHITELIST: {
                return ModConfig.INSTANCE.servers.whitelist.stream().map(String::trim).map(String::toLowerCase).noneMatch(ip::equals);
            }
            case BLACKLIST: {
                return ModConfig.INSTANCE.servers.blacklist.stream().map(String::trim).map(String::toLowerCase).anyMatch(ip::equals);
            }
        }
        throw new IllegalStateException("Unexpected mode value in Freecam.isRestrictedOnServer: " + (Object)((Object)mode));
    }

    static {
        rememberedF5 = null;
    }
}

