/*
 * Decompiled with CFR 0.152.
 */
package net.xolt.freecam.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.shedaniel.autoconfig.ConfigHolder;
import net.minecraft.block.AbstractGlassBlock;
import net.minecraft.block.BarrierBlock;
import net.minecraft.block.Block;
import net.minecraft.block.DoorBlock;
import net.minecraft.block.FenceGateBlock;
import net.minecraft.block.PaneBlock;
import net.minecraft.block.TrapDoorBlock;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.registry.Registry;
import net.xolt.freecam.config.ModConfig;
import net.xolt.freecam.variant.api.BuildVariant;

public class CollisionBehavior {
    private static final Predicate<Block> transparent = Builder.builder().matching(AbstractGlassBlock.class, PaneBlock.class).matching(BarrierBlock.class).build();
    private static final Predicate<Block> openable = Builder.builder().matching(FenceGateBlock.class).matching(DoorBlock.class, TrapDoorBlock.class).build();
    private static Predicate<Block> custom = block -> false;

    public static boolean isIgnored(Block block) {
        if (ModConfig.INSTANCE.collision.ignoreAll && BuildVariant.getInstance().cheatsPermitted()) {
            return true;
        }
        if (ModConfig.INSTANCE.collision.ignoreTransparent && transparent.test(block)) {
            return true;
        }
        if (ModConfig.INSTANCE.collision.ignoreOpenable && openable.test(block)) {
            return true;
        }
        return ModConfig.INSTANCE.collision.ignoreCustom && custom.test(block);
    }

    static ActionResultType onConfigChange(ConfigHolder<ModConfig> holder, ModConfig config) {
        String[] ids = (String[])config.collision.whitelist.ids.stream().map(id -> id.contains(":") ? id : "minecraft:" + id).toArray(String[]::new);
        Pattern[] patterns = (Pattern[])config.collision.whitelist.patterns.stream().map(Pattern::compile).toArray(Pattern[]::new);
        custom = Builder.builder().matching(ids).matching(patterns).build();
        return ActionResultType.PASS;
    }

    private static String getBlockId(Block block) {
        return Registry.field_212618_g.func_177774_c((Object)block).toString();
    }

    private static class Builder {
        private final Collection<Predicate<Block>> predicates = new ArrayList<Predicate<Block>>();

        private Builder() {
        }

        public static Builder builder() {
            return new Builder();
        }

        public final Builder matching(String ... ids) {
            return this.matching((Block block) -> Arrays.asList(ids).contains(CollisionBehavior.getBlockId(block)));
        }

        public final Builder matching(Pattern ... patterns) {
            return this.matching((Block block) -> {
                String id = CollisionBehavior.getBlockId(block);
                return Arrays.stream(patterns).map(pattern -> pattern.matcher(id)).anyMatch(Matcher::find);
            });
        }

        @SafeVarargs
        public final Builder matching(Class<? extends Block> ... classes) {
            return this.matching((Block block) -> Arrays.stream(classes).anyMatch(clazz -> clazz.isInstance(block)));
        }

        public final Builder matching(Predicate<Block> predicate) {
            this.predicates.add(predicate);
            return this;
        }

        public Predicate<Block> build() {
            return block -> this.predicates.stream().anyMatch(predicate -> predicate.test(block));
        }
    }
}

