/*
 * Decompiled with CFR 0.152.
 */
package net.xolt.freecam.config.gui;

import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.ConfigData;
import me.shedaniel.autoconfig.gui.registry.GuiRegistry;
import me.shedaniel.clothconfig2.api.ConfigEntryBuilder;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.xolt.freecam.config.gui.BoundedContinuousImpl;
import net.xolt.freecam.config.gui.CollisionDependencies;
import net.xolt.freecam.config.gui.CollisionWhitelistDependencies;
import net.xolt.freecam.config.gui.ModBindingsConfigImpl;
import net.xolt.freecam.config.gui.ServerRestrictionDependencies;
import net.xolt.freecam.config.gui.ValidateRegexImpl;
import net.xolt.freecam.config.gui.VariantTooltipImpl;

public class AutoConfigExtensions {
    static final ITextComponent RESET_TEXT = new TranslationTextComponent("text.cloth-config.reset_value");
    static final ConfigEntryBuilder ENTRY_BUILDER = ConfigEntryBuilder.create();

    private AutoConfigExtensions() {
    }

    public static void apply(Class<? extends ConfigData> configClass) {
        GuiRegistry registry = AutoConfig.getGuiRegistry(configClass);
        ModBindingsConfigImpl.apply(registry);
        VariantTooltipImpl.apply(registry);
        ValidateRegexImpl.apply(registry);
        BoundedContinuousImpl.apply(registry);
        CollisionDependencies.apply(registry);
        CollisionWhitelistDependencies.apply(registry);
        ServerRestrictionDependencies.apply(registry);
    }

    static Predicate<Field> isField(Class<?> declaringClass, String ... fieldNames) {
        return field -> field.getDeclaringClass().equals(declaringClass) && Arrays.asList(fieldNames).contains(field.getName());
    }

    static Predicate<Field> isArrayOrListOfType(Type ... types) {
        return field -> {
            if (field.getType().isArray()) {
                Class<?> component = field.getType().getComponentType();
                return Arrays.asList(types).contains(component);
            }
            return AutoConfigExtensions.isListOfType(types).test((Field)field);
        };
    }

    static Predicate<Field> isNotArrayOrListOfType(Type ... types) {
        return field -> {
            if (field.getType().isArray()) {
                Class<?> component = field.getType().getComponentType();
                return Arrays.stream(types).noneMatch(component::equals);
            }
            return AutoConfigExtensions.isNotListOfType(types).test((Field)field);
        };
    }

    static Predicate<Field> isListOfType(Type ... types) {
        return field -> {
            if (List.class.isAssignableFrom(field.getType()) && field.getGenericType() instanceof ParameterizedType) {
                ParameterizedType generic = (ParameterizedType)field.getGenericType();
                Type[] args = generic.getActualTypeArguments();
                return args.length == 1 && Arrays.asList(types).contains(args[0]);
            }
            return false;
        };
    }

    static Predicate<Field> isNotListOfType(Type ... types) {
        return field -> {
            if (!List.class.isAssignableFrom(field.getType())) return false;
            if (!(field.getGenericType() instanceof ParameterizedType)) return false;
            ParameterizedType generic = (ParameterizedType)field.getGenericType();
            Type[] args = generic.getActualTypeArguments();
            if (args.length != 1) return false;
            if (!Arrays.stream(types).noneMatch(args[0]::equals)) return false;
            return true;
        };
    }
}

