/*
 * Decompiled with CFR 0.152.
 */
package net.xolt.freecam.config.gui;

import com.google.common.util.concurrent.AtomicDouble;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import me.shedaniel.clothconfig2.gui.entries.TooltipListEntry;
import net.minecraft.client.MainWindow;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.widget.AbstractSlider;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.xolt.freecam.Freecam;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class DoubleSliderEntry
extends TooltipListEntry<Double> {
    private final Slider sliderWidget;
    private final Button resetButton;
    private final AtomicDouble value;
    private final double original;
    private final int precision;
    private final double minimum;
    private final double maximum;
    private final Consumer<Double> saveCallback;
    private final Supplier<Double> defaultValue;
    private final List<Widget> widgets;

    DoubleSliderEntry(ITextComponent fieldName, int precision, double minimum, double maximum, double value, ITextComponent resetText, Supplier<Double> defaultValue, @Nullable Consumer<Double> save) {
        super(fieldName, null);
        this.value = new AtomicDouble(value);
        this.original = value;
        this.defaultValue = defaultValue;
        this.maximum = maximum;
        this.minimum = minimum;
        this.precision = precision;
        this.saveCallback = save;
        this.sliderWidget = new Slider(0, 0, 152, 20, (this.value.get() - minimum) / (maximum - minimum));
        this.sliderWidget.func_230979_b_();
        this.resetButton = new Button(0, 0, Freecam.MC.field_71466_p.func_238414_a_((ITextProperties)resetText) + 6, 20, resetText, widget -> this.setValue(this.defaultValue.get()));
        this.widgets = Collections.unmodifiableList(Arrays.asList(new Widget[]{this.sliderWidget, this.resetButton}));
    }

    public Double getValue() {
        return this.value.get();
    }

    public void setValue(double value) {
        double clamped = MathHelper.func_151237_a((double)value, (double)this.minimum, (double)this.maximum);
        this.value.set(clamped);
        this.sliderWidget.setValue((clamped - this.minimum) / (this.maximum - this.minimum));
        this.sliderWidget.func_230979_b_();
    }

    public boolean isEdited() {
        return super.isEdited() || this.getValue() != this.original;
    }

    public Optional<Double> getDefaultValue() {
        return Optional.ofNullable(this.defaultValue).map(Supplier::get);
    }

    public void save() {
        if (this.saveCallback != null) {
            this.saveCallback.accept(this.getValue());
        }
    }

    @NotNull
    public List<? extends IGuiEventListener> func_231039_at__() {
        return this.widgets;
    }

    public void render(MatrixStack matrices, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isHovered, float delta) {
        super.render(matrices, index, y, x, entryWidth, entryHeight, mouseX, mouseY, isHovered, delta);
        MainWindow window = Freecam.MC.func_228018_at_();
        this.resetButton.field_230693_o_ = this.isEditable() && this.getDefaultValue().isPresent() && this.defaultValue.get().doubleValue() != this.value.get();
        this.resetButton.field_230691_m_ = y;
        this.sliderWidget.field_230693_o_ = this.isEditable();
        this.sliderWidget.field_230691_m_ = y;
        ITextComponent name = this.getDisplayedFieldName();
        if (Freecam.MC.field_71466_p.func_78260_a()) {
            DoubleSliderEntry.func_238475_b_((MatrixStack)matrices, (FontRenderer)Freecam.MC.field_71466_p, (ITextComponent)name, (int)(window.func_198107_o() - x - Freecam.MC.field_71466_p.func_238414_a_((ITextProperties)name)), (int)(y + 6), (int)this.getPreferredTextColor());
            this.resetButton.field_230690_l_ = x;
            this.sliderWidget.field_230690_l_ = x + this.resetButton.func_230998_h_() + 1;
        } else {
            DoubleSliderEntry.func_238475_b_((MatrixStack)matrices, (FontRenderer)Freecam.MC.field_71466_p, (ITextComponent)name, (int)x, (int)(y + 6), (int)this.getPreferredTextColor());
            this.resetButton.field_230690_l_ = x + entryWidth - this.resetButton.func_230998_h_();
            this.sliderWidget.field_230690_l_ = x + entryWidth - 150;
        }
        this.sliderWidget.func_230991_b_(150 - this.resetButton.func_230998_h_() - 2);
        this.resetButton.func_230430_a_(matrices, mouseX, mouseY, delta);
        this.sliderWidget.func_230430_a_(matrices, mouseX, mouseY, delta);
    }

    private final class Slider
    extends AbstractSlider {
        private Slider(int x, int y, int width, int height, double value) {
            super(x, y, width, height, StringTextComponent.field_240750_d_, value);
        }

        public void func_230979_b_() {
            NumberFormat fmt = DecimalFormat.getInstance();
            fmt.setMinimumIntegerDigits(1);
            fmt.setMinimumFractionDigits(DoubleSliderEntry.this.precision);
            fmt.setMaximumFractionDigits(DoubleSliderEntry.this.precision);
            this.func_238482_a_((ITextComponent)new StringTextComponent("Value: " + fmt.format(DoubleSliderEntry.this.value.get())));
        }

        protected void func_230972_a_() {
            double rounded = BigDecimal.valueOf(DoubleSliderEntry.this.minimum + (DoubleSliderEntry.this.maximum - DoubleSliderEntry.this.minimum) * this.field_230683_b_).setScale(DoubleSliderEntry.this.precision, RoundingMode.HALF_UP).doubleValue();
            DoubleSliderEntry.this.value.set(rounded);
        }

        public boolean func_231046_a_(int keyCode, int scanCode, int modifiers) {
            return DoubleSliderEntry.this.isEditable() && super.func_231046_a_(keyCode, scanCode, modifiers);
        }

        public boolean func_231045_a_(double mouseX, double mouseY, int button, double dragX, double dragY) {
            return DoubleSliderEntry.this.isEditable() && super.func_231045_a_(mouseX, mouseY, button, dragX, dragY);
        }

        public void setValue(double value) {
            this.field_230683_b_ = value;
        }
    }
}

