/*
 * Decompiled with CFR 0.152.
 */
package net.xolt.freecam.mixins;

import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.multiplayer.PlayerController;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.xolt.freecam.Freecam;
import net.xolt.freecam.config.ModConfig;
import net.xolt.freecam.variant.api.BuildVariant;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={PlayerController.class})
public class MultiPlayerGameModeMixin {
    @Inject(method={"useItemOn"}, at={@At(value="HEAD")}, cancellable=true)
    private void onInteractBlock(ClientPlayerEntity player, ClientWorld level, Hand hand, BlockRayTraceResult hitResult, CallbackInfoReturnable<ActionResultType> cir) {
        if (MultiPlayerGameModeMixin.freecam$disableInteract()) {
            cir.setReturnValue((Object)ActionResultType.PASS);
        }
    }

    @Inject(method={"interact"}, at={@At(value="HEAD")}, cancellable=true)
    private void onInteractEntity(PlayerEntity player, Entity entity, Hand hand, CallbackInfoReturnable<ActionResultType> cir) {
        if (entity.equals((Object)Freecam.MC.field_71439_g) || MultiPlayerGameModeMixin.freecam$disableInteract()) {
            cir.setReturnValue((Object)ActionResultType.PASS);
        }
    }

    @Inject(method={"interactAt"}, at={@At(value="HEAD")}, cancellable=true)
    private void onInteractEntityAtLocation(PlayerEntity player, Entity entity, EntityRayTraceResult hitResult, Hand hand, CallbackInfoReturnable<ActionResultType> cir) {
        if (entity.equals((Object)Freecam.MC.field_71439_g) || MultiPlayerGameModeMixin.freecam$disableInteract()) {
            cir.setReturnValue((Object)ActionResultType.PASS);
        }
    }

    @Inject(method={"attack"}, at={@At(value="HEAD")}, cancellable=true)
    private void onAttackEntity(PlayerEntity player, Entity target, CallbackInfo ci) {
        if (target.equals((Object)Freecam.MC.field_71439_g)) {
            ci.cancel();
        }
    }

    @Unique
    private static boolean freecam$disableInteract() {
        return Freecam.isEnabled() && !Freecam.isPlayerControlEnabled() && !MultiPlayerGameModeMixin.freecam$allowInteract();
    }

    @Unique
    private static boolean freecam$allowInteract() {
        return ModConfig.INSTANCE.utility.allowInteract && (BuildVariant.getInstance().cheatsPermitted() || ModConfig.INSTANCE.utility.interactionMode.equals((Object)ModConfig.InteractionMode.PLAYER));
    }
}

