/*
 * Decompiled with CFR 0.152.
 */
package net.xolt.freecam.tripod;

import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.world.DimensionType;
import net.xolt.freecam.Freecam;
import net.xolt.freecam.tripod.TripodSlot;
import net.xolt.freecam.util.FreecamPosition;
import org.jetbrains.annotations.Nullable;

public class TripodRegistry {
    private final Map<DimensionType, Map<TripodSlot, FreecamPosition>> tripods = new HashMap<DimensionType, Map<TripodSlot, FreecamPosition>>();

    @Nullable
    public FreecamPosition get(TripodSlot tripod) {
        return this.get(TripodRegistry.dimension(), tripod);
    }

    @Nullable
    public FreecamPosition get(DimensionType dimension, TripodSlot tripod) {
        return Optional.ofNullable(this.tripods.get(dimension)).map(positions -> (FreecamPosition)positions.get((Object)tripod)).orElse(null);
    }

    public void put(TripodSlot tripod, @Nullable FreecamPosition position) {
        this.put(TripodRegistry.dimension(), tripod, position);
    }

    public void put(DimensionType dimension, TripodSlot tripod, @Nullable FreecamPosition position) {
        this.tripods.computeIfAbsent(dimension, TripodRegistry::newEntry).put(tripod, position);
    }

    public void clear() {
        this.tripods.clear();
    }

    private static DimensionType dimension() {
        return Freecam.MC.field_71441_e.func_230315_m_();
    }

    private static Map<TripodSlot, FreecamPosition> newEntry(DimensionType dimension) {
        return new EnumMap<TripodSlot, FreecamPosition>(TripodSlot.class);
    }
}

