/*
 * Decompiled with CFR 0.152.
 */
package net.xolt.freecam.util;

import com.mojang.authlib.GameProfile;
import java.util.UUID;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.PushReaction;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.network.play.ClientPlayNetHandler;
import net.minecraft.entity.Entity;
import net.minecraft.entity.Pose;
import net.minecraft.network.IPacket;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.PacketDirection;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.MovementInputFromOptions;
import net.minecraft.util.math.BlockPos;
import net.xolt.freecam.Freecam;
import net.xolt.freecam.config.ModConfig;
import net.xolt.freecam.util.FreecamPosition;
import net.xolt.freecam.util.Motion;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
@ApiStatus.AvailableSince(value="0.4.0")
public class FreeCamera
extends ClientPlayerEntity {
    private static final ClientPlayNetHandler NETWORK_HANDLER = new ClientPlayNetHandler(Freecam.MC, Freecam.MC.field_71462_r, new NetworkManager(PacketDirection.CLIENTBOUND), new GameProfile(UUID.randomUUID(), "FreeCamera")){

        public void func_147297_a(IPacket<?> packet) {
        }
    };

    public FreeCamera(int id) {
        super(Freecam.MC, Freecam.MC.field_71441_e, NETWORK_HANDLER, Freecam.MC.field_71439_g.func_146107_m(), Freecam.MC.field_71439_g.func_199507_B(), false, false);
        this.func_145769_d(id);
        this.func_213301_b(Pose.SWIMMING);
        this.field_71075_bZ.field_75100_b = true;
        this.field_71158_b = new MovementInputFromOptions(Freecam.MC.field_71474_y);
    }

    public void func_82149_j(Entity entity) {
        this.applyPosition(new FreecamPosition(entity));
    }

    public void applyPosition(FreecamPosition position) {
        this.func_70012_b(position.x, position.y, position.z, position.yaw, position.pitch);
        this.field_71155_g = this.field_70125_A;
        this.field_71154_f = this.field_70177_z;
        this.field_71164_i = this.field_71155_g;
        this.field_71163_h = this.field_71154_f;
    }

    public void applyPerspective(ModConfig.Perspective perspective, boolean checkCollision) {
        FreecamPosition position = new FreecamPosition((Entity)this);
        switch (perspective) {
            case INSIDE: {
                break;
            }
            case FIRST_PERSON: {
                this.moveForwardUntilCollision(position, 0.4, checkCollision);
                break;
            }
            case THIRD_PERSON_MIRROR: {
                position.mirrorRotation();
            }
            case THIRD_PERSON: {
                this.moveForwardUntilCollision(position, -4.0, checkCollision);
            }
        }
    }

    private boolean moveForwardUntilCollision(FreecamPosition position, double distance, boolean checkCollision) {
        if (!checkCollision) {
            position.moveForward(distance);
            this.applyPosition(position);
            return true;
        }
        return this.moveForwardUntilCollision(position, distance);
    }

    private boolean moveForwardUntilCollision(FreecamPosition position, double maxDistance) {
        boolean negative = maxDistance < 0.0;
        maxDistance = negative ? -1.0 * maxDistance : maxDistance;
        double increment = 0.1;
        for (double distance = 0.0; distance < maxDistance; distance += increment) {
            FreecamPosition oldPosition = new FreecamPosition((Entity)this);
            position.moveForward(negative ? -1.0 * increment : increment);
            this.applyPosition(position);
            if (this.func_213298_c(this.func_213283_Z())) continue;
            this.applyPosition(oldPosition);
            return distance > 0.0;
        }
        return true;
    }

    public void spawn() {
        this.field_213837_d.func_217411_a(this.func_145782_y(), (Entity)this);
    }

    public void despawn() {
        this.field_213837_d.func_217413_d(this.func_145782_y());
    }

    protected void func_184231_a(double heightDifference, boolean onGround, BlockState landedState, BlockPos landedPosition) {
    }

    public float func_70678_g(float tickDelta) {
        return Freecam.MC.field_71439_g.func_70678_g(tickDelta);
    }

    public int func_184605_cv() {
        return Freecam.MC.field_71439_g.func_184605_cv();
    }

    public boolean func_184587_cr() {
        return Freecam.MC.field_71439_g.func_184587_cr();
    }

    public boolean func_70617_f_() {
        return false;
    }

    public boolean func_70090_H() {
        return false;
    }

    public EffectInstance func_70660_b(Effect effect) {
        return Freecam.MC.field_71439_g.func_70660_b(effect);
    }

    public PushReaction func_184192_z() {
        return ModConfig.INSTANCE.collision.ignoreAll ? PushReaction.IGNORE : PushReaction.NORMAL;
    }

    public boolean func_241849_j(Entity other) {
        return false;
    }

    public void func_213301_b(Pose pose) {
        super.func_213301_b(Pose.SWIMMING);
    }

    public boolean func_228354_I_() {
        return false;
    }

    protected boolean func_204229_de() {
        this.field_204230_bP = this.func_208600_a((ITag)FluidTags.field_206959_a);
        return this.field_204230_bP;
    }

    protected void func_71061_d_() {
    }

    public void func_70636_d() {
        if (ModConfig.INSTANCE.movement.flightMode.equals((Object)ModConfig.FlightMode.DEFAULT)) {
            this.field_71075_bZ.func_195931_a(0.0f);
            Motion.doMotion(this, ModConfig.INSTANCE.movement.horizontalSpeed, ModConfig.INSTANCE.movement.verticalSpeed);
        } else {
            this.field_71075_bZ.func_195931_a((float)ModConfig.INSTANCE.movement.verticalSpeed / 10.0f);
        }
        super.func_70636_d();
        this.field_71075_bZ.field_75100_b = true;
        this.func_230245_c_(false);
    }
}

