/*
 * Decompiled with CFR 0.152.
 */
package net.xolt.freecam.util;

import net.minecraft.entity.Entity;
import net.minecraft.entity.Pose;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3f;

public class FreecamPosition {
    public double x;
    public double y;
    public double z;
    public float pitch;
    public float yaw;
    private final Quaternion rotation = new Quaternion(0.0f, 0.0f, 0.0f, 1.0f);
    private final Vector3f verticalPlane = new Vector3f(0.0f, 1.0f, 0.0f);
    private final Vector3f diagonalPlane = new Vector3f(1.0f, 0.0f, 0.0f);
    private final Vector3f horizontalPlane = new Vector3f(0.0f, 0.0f, 1.0f);

    public FreecamPosition(Entity entity) {
        this.x = entity.func_226277_ct_();
        this.y = FreecamPosition.getSwimmingY(entity);
        this.z = entity.func_226281_cx_();
        this.setRotation(entity.field_70177_z, entity.field_70125_A);
    }

    public void setRotation(float yaw, float pitch) {
        this.pitch = pitch;
        this.yaw = yaw;
        this.rotation.func_227066_a_(0.0f, 0.0f, 0.0f, 1.0f);
        this.rotation.func_195890_a(Vector3f.field_229181_d_.func_229187_a_(-yaw));
        this.rotation.func_195890_a(Vector3f.field_229179_b_.func_229187_a_(pitch));
        this.horizontalPlane.func_195905_a(0.0f, 0.0f, 1.0f);
        this.horizontalPlane.func_214905_a(this.rotation);
        this.verticalPlane.func_195905_a(0.0f, 1.0f, 0.0f);
        this.verticalPlane.func_214905_a(this.rotation);
        this.diagonalPlane.func_195905_a(1.0f, 0.0f, 0.0f);
        this.diagonalPlane.func_214905_a(this.rotation);
    }

    public void mirrorRotation() {
        this.setRotation(this.yaw + 180.0f, -this.pitch);
    }

    public void moveForward(double distance) {
        this.move(distance, 0.0, 0.0);
    }

    public void move(double fwd, double up, double right) {
        this.x += (double)this.horizontalPlane.func_195899_a() * fwd + (double)this.verticalPlane.func_195899_a() * up + (double)this.diagonalPlane.func_195899_a() * right;
        this.y += (double)this.horizontalPlane.func_195900_b() * fwd + (double)this.verticalPlane.func_195900_b() * up + (double)this.diagonalPlane.func_195900_b() * right;
        this.z += (double)this.horizontalPlane.func_195902_c() * fwd + (double)this.verticalPlane.func_195902_c() * up + (double)this.diagonalPlane.func_195902_c() * right;
    }

    public ChunkPos getChunkPos() {
        return new ChunkPos((int)(this.x / 16.0), (int)(this.z / 16.0));
    }

    private static double getSwimmingY(Entity entity) {
        if (entity.func_213283_Z() == Pose.SWIMMING) {
            return entity.func_226278_cu_();
        }
        return entity.func_226278_cu_() - (double)entity.func_213307_e(Pose.SWIMMING) + (double)entity.func_213307_e(entity.func_213283_Z());
    }
}

