/*
 * Decompiled with CFR 0.152.
 */
package net.xolt.freecam;

import net.minecraft.client.CameraType;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.client.player.Input;
import net.minecraft.client.player.KeyboardInput;
import net.minecraft.client.renderer.texture.Tickable;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ChunkPos;
import net.xolt.freecam.config.ModBindings;
import net.xolt.freecam.config.ModConfig;
import net.xolt.freecam.tripod.TripodRegistry;
import net.xolt.freecam.tripod.TripodSlot;
import net.xolt.freecam.util.FreeCamera;
import net.xolt.freecam.util.FreecamPosition;
import net.xolt.freecam.variant.api.BuildVariant;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public class Freecam {
    public static final Minecraft MC = Minecraft.m_91087_();
    public static final String MOD_ID = "freecam";
    private static boolean freecamEnabled = false;
    private static boolean tripodEnabled = false;
    private static boolean playerControlEnabled = false;
    private static boolean disableNextTick = false;
    private static final TripodRegistry tripods = new TripodRegistry();
    private static TripodSlot activeTripod = TripodSlot.NONE;
    private static FreeCamera freeCamera;
    private static CameraType rememberedF5;

    @ApiStatus.Internal
    public static void preTick(Minecraft mc) {
        if ((disableNextTick || Freecam.isRestrictedOnServer()) && Freecam.isEnabled()) {
            Freecam.toggle();
        }
        disableNextTick = false;
        if (Freecam.isEnabled()) {
            if (mc.f_91074_ != null && mc.f_91074_.f_108618_ instanceof KeyboardInput && !Freecam.isPlayerControlEnabled()) {
                Input input = new Input();
                input.f_108573_ = mc.f_91074_.f_108618_.f_108573_;
                mc.f_91074_.f_108618_ = input;
            }
            mc.f_91063_.m_172736_(ModConfig.INSTANCE.visual.showHand);
        }
    }

    @ApiStatus.Internal
    public static void postTick(Minecraft mc) {
        ModBindings.forEach(Tickable::m_7673_);
    }

    @ApiStatus.Internal
    public static void onDisconnect() {
        if (Freecam.isEnabled()) {
            Freecam.toggle();
        }
        tripods.clear();
    }

    @ApiStatus.Internal
    public static boolean activateTripodHandler() {
        boolean activated = false;
        for (KeyMapping combo : Freecam.MC.f_91066_.f_92056_) {
            while (combo.m_90859_()) {
                Freecam.toggleTripod(TripodSlot.ofKeyCode(combo.m_90861_().m_84873_()));
                activated = true;
            }
        }
        return activated;
    }

    @ApiStatus.Internal
    public static boolean resetTripodHandler() {
        boolean reset = false;
        for (KeyMapping key : Freecam.MC.f_91066_.f_92056_) {
            while (key.m_90859_()) {
                Freecam.resetCamera(TripodSlot.ofKeyCode(key.m_90861_().m_84873_()));
                reset = true;
            }
        }
        return reset;
    }

    @ApiStatus.AvailableSince(value="0.3.1")
    public static void toggle() {
        if (Freecam.isRestrictedOnServer()) {
            if (ModConfig.INSTANCE.notification.notifyFreecam) {
                Freecam.MC.f_91074_.m_5661_((Component)new TranslatableComponent("msg.freecam.restrictedByConfig", new Object[]{Freecam.MC.m_91089_().f_105363_}), true);
            }
            return;
        }
        if (tripodEnabled) {
            Freecam.toggleTripod(activeTripod);
            return;
        }
        if (freecamEnabled) {
            Freecam.onDisableFreecam();
        } else {
            Freecam.onEnableFreecam();
        }
        boolean bl = freecamEnabled = !freecamEnabled;
        if (!freecamEnabled) {
            Freecam.onDisabled();
        }
    }

    private static void toggleTripod(TripodSlot tripod) {
        if (tripod == TripodSlot.NONE) {
            return;
        }
        if (Freecam.isRestrictedOnServer()) {
            if (ModConfig.INSTANCE.notification.notifyTripod) {
                Freecam.MC.f_91074_.m_5661_((Component)new TranslatableComponent("msg.freecam.restrictedByConfig", new Object[]{Freecam.MC.m_91089_().f_105363_}), true);
            }
            return;
        }
        if (tripodEnabled) {
            if (activeTripod == tripod) {
                Freecam.onDisableTripod();
                tripodEnabled = false;
            } else {
                Freecam.onDisableTripod();
                Freecam.onEnableTripod(tripod);
            }
        } else {
            if (freecamEnabled) {
                Freecam.toggle();
            }
            Freecam.onEnableTripod(tripod);
            tripodEnabled = true;
        }
        if (!tripodEnabled) {
            Freecam.onDisabled();
        }
    }

    @ApiStatus.AvailableSince(value="1.1.8")
    public static void switchControls() {
        if (!Freecam.isEnabled()) {
            return;
        }
        if (playerControlEnabled) {
            Freecam.freeCamera.f_108618_ = new KeyboardInput(Freecam.MC.f_91066_);
        } else {
            Freecam.MC.f_91074_.f_108618_ = new KeyboardInput(Freecam.MC.f_91066_);
            Freecam.freeCamera.f_108618_ = new Input();
        }
        playerControlEnabled = !playerControlEnabled;
    }

    private static void onEnableTripod(TripodSlot tripod) {
        Freecam.onEnable();
        FreecamPosition position = tripods.get(tripod);
        boolean chunkLoaded = false;
        if (position != null) {
            ChunkPos chunkPos = position.getChunkPos();
            chunkLoaded = Freecam.MC.f_91073_.m_7726_().m_5563_(chunkPos.f_45578_, chunkPos.f_45579_);
        }
        if (!chunkLoaded) {
            Freecam.resetCamera(tripod);
            position = null;
        }
        freeCamera = new FreeCamera(-420 - tripod.ordinal());
        if (position == null) {
            Freecam.moveToPlayer();
        } else {
            Freecam.moveToPosition(position);
        }
        freeCamera.spawn();
        MC.m_91118_((Entity)freeCamera);
        activeTripod = tripod;
        if (ModConfig.INSTANCE.notification.notifyTripod) {
            Freecam.MC.f_91074_.m_5661_((Component)new TranslatableComponent("msg.freecam.openTripod", new Object[]{tripod}), true);
        }
    }

    private static void onDisableTripod() {
        tripods.put(activeTripod, new FreecamPosition((Entity)freeCamera));
        Freecam.onDisable();
        if (Freecam.MC.f_91074_ != null && ModConfig.INSTANCE.notification.notifyTripod) {
            Freecam.MC.f_91074_.m_5661_((Component)new TranslatableComponent("msg.freecam.closeTripod", new Object[]{activeTripod}), true);
        }
        activeTripod = TripodSlot.NONE;
    }

    private static void onEnableFreecam() {
        Freecam.onEnable();
        freeCamera = new FreeCamera(-420);
        Freecam.moveToPlayer();
        freeCamera.spawn();
        MC.m_91118_((Entity)freeCamera);
        if (ModConfig.INSTANCE.notification.notifyFreecam) {
            Freecam.MC.f_91074_.m_5661_((Component)new TranslatableComponent("msg.freecam.enable"), true);
        }
    }

    private static void onDisableFreecam() {
        Freecam.onDisable();
        if (Freecam.MC.f_91074_ != null && ModConfig.INSTANCE.notification.notifyFreecam) {
            Freecam.MC.f_91074_.m_5661_((Component)new TranslatableComponent("msg.freecam.disable"), true);
        }
    }

    private static void onEnable() {
        Freecam.MC.f_90980_ = false;
        Freecam.MC.f_91063_.m_172736_(ModConfig.INSTANCE.visual.showHand);
        rememberedF5 = Freecam.MC.f_91066_.m_92176_();
        if (Freecam.MC.f_91063_.m_109153_().m_90594_()) {
            Freecam.MC.f_91066_.m_92157_(CameraType.FIRST_PERSON);
        }
    }

    private static void onDisable() {
        Freecam.MC.f_90980_ = true;
        Freecam.MC.f_91063_.m_172736_(true);
        MC.m_91118_((Entity)Freecam.MC.f_91074_);
        playerControlEnabled = false;
        freeCamera.despawn();
        Freecam.freeCamera.f_108618_ = new Input();
        freeCamera = null;
        if (Freecam.MC.f_91074_ != null) {
            Freecam.MC.f_91074_.f_108618_ = new KeyboardInput(Freecam.MC.f_91066_);
        }
    }

    private static void onDisabled() {
        if (rememberedF5 != null) {
            Freecam.MC.f_91066_.m_92157_(rememberedF5);
        }
    }

    private static void resetCamera(TripodSlot tripod) {
        if (tripodEnabled && activeTripod != TripodSlot.NONE && activeTripod == tripod && freeCamera != null) {
            Freecam.moveToPlayer();
        } else {
            tripods.put(tripod, null);
        }
        if (ModConfig.INSTANCE.notification.notifyTripod) {
            Freecam.MC.f_91074_.m_5661_((Component)new TranslatableComponent("msg.freecam.tripodReset", new Object[]{tripod}), true);
        }
    }

    @ApiStatus.Experimental
    @ApiStatus.AvailableSince(value="1.2.3")
    public static void moveToEntity(@Nullable Entity entity) {
        if (freeCamera == null) {
            return;
        }
        if (entity == null) {
            Freecam.moveToPlayer();
            return;
        }
        freeCamera.m_20359_(entity);
    }

    @ApiStatus.Experimental
    @ApiStatus.AvailableSince(value="1.2.3")
    public static void moveToPosition(@Nullable FreecamPosition position) {
        if (freeCamera == null) {
            return;
        }
        if (position == null) {
            Freecam.moveToPlayer();
            return;
        }
        freeCamera.applyPosition(position);
    }

    @ApiStatus.Experimental
    @ApiStatus.AvailableSince(value="1.2.3")
    public static void moveToPlayer() {
        if (freeCamera == null) {
            return;
        }
        freeCamera.m_20359_((Entity)Freecam.MC.f_91074_);
        freeCamera.applyPerspective(ModConfig.INSTANCE.visual.perspective, ModConfig.INSTANCE.collision.alwaysCheck || !ModConfig.INSTANCE.collision.ignoreAll || !BuildVariant.getInstance().cheatsPermitted());
    }

    @ApiStatus.AvailableSince(value="0.4.0")
    public static FreeCamera getFreeCamera() {
        return freeCamera;
    }

    @ApiStatus.AvailableSince(value="1.2.3")
    public static void disableNextTick() {
        disableNextTick = true;
    }

    @ApiStatus.AvailableSince(value="0.2.2")
    public static boolean isEnabled() {
        return freecamEnabled || tripodEnabled;
    }

    @ApiStatus.Experimental
    @ApiStatus.AvailableSince(value="1.0.0")
    public static boolean isPlayerControlEnabled() {
        return playerControlEnabled;
    }

    @ApiStatus.Experimental
    @ApiStatus.AvailableSince(value="1.2.4")
    public static boolean isRestrictedOnServer() {
        ServerData server = MC.m_91089_();
        ModConfig.ServerRestriction mode = ModConfig.INSTANCE.servers.mode;
        if (mode == ModConfig.ServerRestriction.NONE || server == null || MC.m_91091_()) {
            return false;
        }
        String ip = server.f_105363_.trim().toLowerCase();
        return switch (mode) {
            case ModConfig.ServerRestriction.WHITELIST -> ModConfig.INSTANCE.servers.whitelist.stream().map(String::trim).map(String::toLowerCase).noneMatch(ip::equals);
            case ModConfig.ServerRestriction.BLACKLIST -> ModConfig.INSTANCE.servers.blacklist.stream().map(String::trim).map(String::toLowerCase).anyMatch(ip::equals);
            default -> throw new IllegalStateException("Unexpected mode value in Freecam.isRestrictedOnServer: " + String.valueOf((Object)mode));
        };
    }

    static {
        rememberedF5 = null;
    }
}

