/*
 * Decompiled with CFR 0.152.
 */
package net.xolt.freecam.util;

import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.level.ChunkPos;

public class FreecamPosition {
    public double x;
    public double y;
    public double z;
    public float pitch;
    public float yaw;
    private final Quaternion rotation = new Quaternion(0.0f, 0.0f, 0.0f, 1.0f);
    private final Vector3f verticalPlane = new Vector3f(0.0f, 1.0f, 0.0f);
    private final Vector3f diagonalPlane = new Vector3f(1.0f, 0.0f, 0.0f);
    private final Vector3f horizontalPlane = new Vector3f(0.0f, 0.0f, 1.0f);

    public FreecamPosition(Entity entity) {
        this.x = entity.m_20185_();
        this.y = FreecamPosition.getSwimmingY(entity);
        this.z = entity.m_20189_();
        this.setRotation(entity.m_146908_(), entity.m_146909_());
    }

    public void setRotation(float yaw, float pitch) {
        this.pitch = pitch;
        this.yaw = yaw;
        this.rotation.m_80143_(0.0f, 0.0f, 0.0f, 1.0f);
        this.rotation.m_80148_(Vector3f.f_122225_.m_122240_(-yaw));
        this.rotation.m_80148_(Vector3f.f_122223_.m_122240_(pitch));
        this.horizontalPlane.m_122245_(0.0f, 0.0f, 1.0f);
        this.horizontalPlane.m_122251_(this.rotation);
        this.verticalPlane.m_122245_(0.0f, 1.0f, 0.0f);
        this.verticalPlane.m_122251_(this.rotation);
        this.diagonalPlane.m_122245_(1.0f, 0.0f, 0.0f);
        this.diagonalPlane.m_122251_(this.rotation);
    }

    public void mirrorRotation() {
        this.setRotation(this.yaw + 180.0f, -this.pitch);
    }

    public void moveForward(double distance) {
        this.move(distance, 0.0, 0.0);
    }

    public void move(double fwd, double up, double right) {
        this.x += (double)this.horizontalPlane.m_122239_() * fwd + (double)this.verticalPlane.m_122239_() * up + (double)this.diagonalPlane.m_122239_() * right;
        this.y += (double)this.horizontalPlane.m_122260_() * fwd + (double)this.verticalPlane.m_122260_() * up + (double)this.diagonalPlane.m_122260_() * right;
        this.z += (double)this.horizontalPlane.m_122269_() * fwd + (double)this.verticalPlane.m_122269_() * up + (double)this.diagonalPlane.m_122269_() * right;
    }

    public ChunkPos getChunkPos() {
        return new ChunkPos((int)(this.x / 16.0), (int)(this.z / 16.0));
    }

    private static double getSwimmingY(Entity entity) {
        if (entity.m_20089_() == Pose.SWIMMING) {
            return entity.m_20186_();
        }
        return entity.m_20186_() - (double)entity.m_20236_(Pose.SWIMMING) + (double)entity.m_20236_(entity.m_20089_());
    }
}

