/*
 * Decompiled with CFR 0.152.
 */
package net.xolt.freecam.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.shedaniel.autoconfig.ConfigHolder;
import net.minecraft.class_1269;
import net.minecraft.class_2213;
import net.minecraft.class_2248;
import net.minecraft.class_2323;
import net.minecraft.class_2349;
import net.minecraft.class_2378;
import net.minecraft.class_2389;
import net.minecraft.class_2533;
import net.minecraft.class_4262;
import net.xolt.freecam.config.ModConfig;
import net.xolt.freecam.variant.api.BuildVariant;

public class CollisionBehavior {
    private static final Predicate<class_2248> transparent = Builder.builder().matching(class_4262.class, class_2389.class).matching(class_2213.class).build();
    private static final Predicate<class_2248> openable = Builder.builder().matching(class_2349.class).matching(class_2323.class, class_2533.class).build();
    private static Predicate<class_2248> custom = block -> false;

    public static boolean isIgnored(class_2248 block) {
        if (ModConfig.INSTANCE.collision.ignoreAll && BuildVariant.getInstance().cheatsPermitted()) {
            return true;
        }
        if (ModConfig.INSTANCE.collision.ignoreTransparent && transparent.test(block)) {
            return true;
        }
        if (ModConfig.INSTANCE.collision.ignoreOpenable && openable.test(block)) {
            return true;
        }
        return ModConfig.INSTANCE.collision.ignoreCustom && custom.test(block);
    }

    static class_1269 onConfigChange(ConfigHolder<ModConfig> holder, ModConfig config) {
        String[] ids = (String[])config.collision.whitelist.ids.stream().map(id -> id.contains(":") ? id : "minecraft:" + id).toArray(String[]::new);
        Pattern[] patterns = (Pattern[])config.collision.whitelist.patterns.stream().map(Pattern::compile).toArray(Pattern[]::new);
        custom = Builder.builder().matching(ids).matching(patterns).build();
        return class_1269.field_5811;
    }

    private static String getBlockId(class_2248 block) {
        return class_2378.field_11146.method_10221((Object)block).toString();
    }

    private static class Builder {
        private final Collection<Predicate<class_2248>> predicates = new ArrayList<Predicate<class_2248>>();

        private Builder() {
        }

        public static Builder builder() {
            return new Builder();
        }

        public final Builder matching(String ... ids) {
            return this.matching((class_2248 block) -> Arrays.asList(ids).contains(CollisionBehavior.getBlockId(block)));
        }

        public final Builder matching(Pattern ... patterns) {
            return this.matching((class_2248 block) -> {
                String id = CollisionBehavior.getBlockId(block);
                return Arrays.stream(patterns).map(pattern -> pattern.matcher(id)).anyMatch(Matcher::find);
            });
        }

        @SafeVarargs
        public final Builder matching(Class<? extends class_2248> ... classes) {
            return this.matching((class_2248 block) -> Arrays.stream(classes).anyMatch(clazz -> clazz.isInstance(block)));
        }

        public final Builder matching(Predicate<class_2248> predicate) {
            this.predicates.add(predicate);
            return this;
        }

        public Predicate<class_2248> build() {
            return block -> this.predicates.stream().anyMatch(predicate -> predicate.test(block));
        }
    }
}

