/*
 * Decompiled with CFR 0.152.
 */
package net.xolt.freecam.config.gui;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import me.shedaniel.autoconfig.gui.registry.GuiRegistry;
import me.shedaniel.clothconfig2.api.ReferenceProvider;
import me.shedaniel.clothconfig2.gui.entries.BooleanListEntry;
import net.xolt.freecam.variant.api.BuildVariant;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

class CollisionDependencies {
    private static final Logger LOGGER = LogManager.getLogger();
    private static ReferenceProvider<Boolean> ignoreAllWidget;

    private CollisionDependencies() {
    }

    static void apply(GuiRegistry guiRegistry) {
        guiRegistry.registerPredicateTransformer((guis, i18n, field, config, defaults, registry) -> {
            List widgets = guis.stream().filter(BooleanListEntry.class::isInstance).map(BooleanListEntry.class::cast).collect(Collectors.toList());
            if (widgets.isEmpty()) {
                LOGGER.error("Unable to find ignoreAll widget.");
                return guis;
            }
            if (widgets.size() > 1) {
                LOGGER.warn("Multiple ignoreAll widgets, choosing first.");
            }
            ignoreAllWidget = (ReferenceProvider)widgets.get(0);
            return guis;
        }, field -> field.getName().equals("ignoreAll"));
        guiRegistry.registerPredicateTransformer((guis, i18n, field, config, defaults, registry) -> {
            if (BuildVariant.getInstance().name().equals("modrinth")) {
                return guis;
            }
            guis.stream().filter(BooleanListEntry.class::isInstance).map(BooleanListEntry.class::cast).forEach(gui -> gui.setRequirement(CollisionDependencies::notIgnoreAll));
            return guis;
        }, field -> Arrays.asList("ignoreTransparent", "ignoreOpenable", "ignoreCustom").contains(field.getName()));
    }

    private static boolean notIgnoreAll() {
        return ignoreAllWidget == null || Boolean.FALSE.equals(ignoreAllWidget.provideReferenceEntry().getValue());
    }
}

