/*
 * Decompiled with CFR 0.152.
 */
package net.xolt.freecam.config.gui;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import me.shedaniel.autoconfig.gui.registry.GuiRegistry;
import me.shedaniel.clothconfig2.api.AbstractConfigListEntry;
import me.shedaniel.clothconfig2.gui.entries.TextListEntry;
import me.shedaniel.clothconfig2.gui.entries.TooltipListEntry;
import net.minecraft.class_2477;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.xolt.freecam.config.gui.VariantTooltip;
import net.xolt.freecam.variant.api.BuildVariant;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Contract;

class VariantTooltipImpl {
    private VariantTooltipImpl() {
    }

    static void apply(GuiRegistry registry) {
        registry.registerAnnotationTransformer((guis, i18n, field, config, defaults, guiProvider) -> {
            VariantTooltip tooltip = field.getAnnotation(VariantTooltip.class);
            VariantTooltipImpl.applyVariantTooltip(guis, Collections.singletonList(tooltip), i18n);
            return guis;
        }, new Class[]{VariantTooltip.class});
        registry.registerAnnotationTransformer((guis, i18n, field, config, defaults, guiProvider) -> {
            VariantTooltip.List tooltips = field.getAnnotation(VariantTooltip.List.class);
            VariantTooltipImpl.applyVariantTooltip(guis, Arrays.asList(tooltips.value()), i18n);
            return guis;
        }, new Class[]{VariantTooltip.List.class});
    }

    @Contract(mutates="param1")
    private static void applyVariantTooltip(List<AbstractConfigListEntry> guis, List<VariantTooltip> tooltipVariants, String i18n) {
        String variant = BuildVariant.getInstance().name();
        List<String> variants = Arrays.asList(variant, "all");
        int count = tooltipVariants.stream().filter(entry -> variants.contains(entry.variant())).mapToInt(VariantTooltip::count).reduce((prev, next) -> {
            throw new IllegalArgumentException(String.format("%s: Multiple variants matching \"%s\" declared on \"%s\".", VariantTooltip.class.getSimpleName(), variant, i18n));
        }).orElseThrow(() -> new IllegalStateException(String.format("%s: No variants matching \"%s\" declared on \"%s\".", VariantTooltip.class.getSimpleName(), variant, i18n)));
        boolean multiline = tooltipVariants.stream().mapToInt(VariantTooltip::count).anyMatch(c -> c > 1);
        guis.stream().filter(gui -> !(gui instanceof TextListEntry)).filter(TooltipListEntry.class::isInstance).map(gui -> (TooltipListEntry)gui).forEach(gui -> gui.setTooltipSupplier(VariantTooltipImpl.getVariantTooltip(variant, i18n, count, multiline)));
    }

    private static Supplier<Optional<class_2561[]>> getVariantTooltip(String variant, String i18n, int count, boolean indexed) {
        if (count == 0) {
            return Optional::empty;
        }
        Optional<A[]> tooltip = Optional.of(IntStream.range(0, count).mapToObj(i -> VariantTooltipImpl.getVariantTooltipLine(variant, i18n, i, indexed)).toArray(class_2561[]::new));
        return () -> tooltip;
    }

    private static class_2561 getVariantTooltipLine(String variant, String i18n, int index, boolean indexed) {
        String key = String.format("%s.@%sTooltip", i18n, StringUtils.capitalize((String)variant));
        if (indexed) {
            key = key + String.format("[%d]", index);
        }
        if (class_2477.method_10517().method_4678(key)) {
            return new class_2588(key);
        }
        if (variant.isEmpty()) {
            return class_2585.field_24366;
        }
        return VariantTooltipImpl.getVariantTooltipLine("", i18n, index, indexed);
    }
}

