/*
 * Decompiled with CFR 0.152.
 */
package net.xolt.freecam.util;

import com.mojang.authlib.GameProfile;
import java.util.UUID;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_2338;
import net.minecraft.class_2535;
import net.minecraft.class_2596;
import net.minecraft.class_2598;
import net.minecraft.class_2680;
import net.minecraft.class_3486;
import net.minecraft.class_3494;
import net.minecraft.class_3619;
import net.minecraft.class_4050;
import net.minecraft.class_634;
import net.minecraft.class_743;
import net.minecraft.class_746;
import net.xolt.freecam.Freecam;
import net.xolt.freecam.config.ModConfig;
import net.xolt.freecam.util.FreecamPosition;
import net.xolt.freecam.util.Motion;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
@ApiStatus.AvailableSince(value="0.4.0")
public class FreeCamera
extends class_746 {
    private static final class_634 NETWORK_HANDLER = new class_634(Freecam.MC, Freecam.MC.field_1755, new class_2535(class_2598.field_11942), new GameProfile(UUID.randomUUID(), "FreeCamera")){

        public void method_2883(class_2596<?> packet) {
        }
    };

    public FreeCamera(int id) {
        super(Freecam.MC, Freecam.MC.field_1687, NETWORK_HANDLER, Freecam.MC.field_1724.method_3143(), Freecam.MC.field_1724.method_3130(), false, false);
        this.method_5838(id);
        this.method_18380(class_4050.field_18079);
        this.field_7503.field_7479 = true;
        this.field_3913 = new class_743(Freecam.MC.field_1690);
    }

    public void method_5719(class_1297 entity) {
        this.applyPosition(new FreecamPosition(entity));
    }

    public void applyPosition(FreecamPosition position) {
        this.method_5808(position.x, position.y, position.z, position.yaw, position.pitch);
        this.field_3916 = this.field_5965;
        this.field_3932 = this.field_6031;
        this.field_3914 = this.field_3916;
        this.field_3931 = this.field_3932;
    }

    public void applyPerspective(ModConfig.Perspective perspective, boolean checkCollision) {
        FreecamPosition position = new FreecamPosition((class_1297)this);
        switch (perspective) {
            case INSIDE: {
                break;
            }
            case FIRST_PERSON: {
                this.moveForwardUntilCollision(position, 0.4, checkCollision);
                break;
            }
            case THIRD_PERSON_MIRROR: {
                position.mirrorRotation();
            }
            case THIRD_PERSON: {
                this.moveForwardUntilCollision(position, -4.0, checkCollision);
            }
        }
    }

    private boolean moveForwardUntilCollision(FreecamPosition position, double distance, boolean checkCollision) {
        if (!checkCollision) {
            position.moveForward(distance);
            this.applyPosition(position);
            return true;
        }
        return this.moveForwardUntilCollision(position, distance);
    }

    private boolean moveForwardUntilCollision(FreecamPosition position, double maxDistance) {
        boolean negative = maxDistance < 0.0;
        maxDistance = negative ? -1.0 * maxDistance : maxDistance;
        double increment = 0.1;
        for (double distance = 0.0; distance < maxDistance; distance += increment) {
            FreecamPosition oldPosition = new FreecamPosition((class_1297)this);
            position.moveForward(negative ? -1.0 * increment : increment);
            this.applyPosition(position);
            if (this.method_20233(this.method_18376())) continue;
            this.applyPosition(oldPosition);
            return distance > 0.0;
        }
        return true;
    }

    public void spawn() {
        this.field_17892.method_2942(this.method_5628(), (class_1297)this);
    }

    public void despawn() {
        this.field_17892.method_2945(this.method_5628());
    }

    protected void method_5623(double heightDifference, boolean onGround, class_2680 landedState, class_2338 landedPosition) {
    }

    public float method_6055(float tickDelta) {
        return Freecam.MC.field_1724.method_6055(tickDelta);
    }

    public int method_6014() {
        return Freecam.MC.field_1724.method_6014();
    }

    public boolean method_6115() {
        return Freecam.MC.field_1724.method_6115();
    }

    public boolean method_6101() {
        return false;
    }

    public boolean method_5799() {
        return false;
    }

    public class_1293 method_6112(class_1291 effect) {
        return Freecam.MC.field_1724.method_6112(effect);
    }

    public class_3619 method_5657() {
        return ModConfig.INSTANCE.collision.ignoreAll ? class_3619.field_15975 : class_3619.field_15974;
    }

    public boolean method_30949(class_1297 other) {
        return false;
    }

    public void method_18380(class_4050 pose) {
        super.method_18380(class_4050.field_18079);
    }

    public boolean method_20303() {
        return false;
    }

    protected boolean method_7295() {
        this.field_7490 = this.method_5777((class_3494)class_3486.field_15517);
        return this.field_7490;
    }

    protected void method_5746() {
    }

    public void method_6007() {
        if (ModConfig.INSTANCE.movement.flightMode.equals((Object)ModConfig.FlightMode.DEFAULT)) {
            this.field_7503.method_7248(0.0f);
            Motion.doMotion(this, ModConfig.INSTANCE.movement.horizontalSpeed, ModConfig.INSTANCE.movement.verticalSpeed);
        } else {
            this.field_7503.method_7248((float)ModConfig.INSTANCE.movement.verticalSpeed / 10.0f);
        }
        super.method_6007();
        this.field_7503.field_7479 = true;
        this.method_24830(false);
    }
}

