/*
 * Decompiled with CFR 0.152.
 */
package fionathemortal.betterbiomeblend.mixin;

import fionathemortal.betterbiomeblend.BetterBiomeBlendClient;
import fionathemortal.betterbiomeblend.common.BlendCache;
import fionathemortal.betterbiomeblend.common.BlendChunk;
import fionathemortal.betterbiomeblend.common.ColorBlending;
import fionathemortal.betterbiomeblend.common.ColorCaching;
import fionathemortal.betterbiomeblend.common.CustomColorResolverCompatibility;
import fionathemortal.betterbiomeblend.common.LocalCache;
import fionathemortal.betterbiomeblend.common.cache.ColorCache;
import fionathemortal.betterbiomeblend.common.debug.Debug;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.util.function.Supplier;
import net.minecraft.client.color.block.BlockTintCache;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ColorResolver;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.storage.WritableLevelData;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ClientLevel.class})
public abstract class MixinClientWorld
extends Level {
    @Shadow
    private final Object2ObjectArrayMap<ColorResolver, BlockTintCache> f_104558_ = new Object2ObjectArrayMap();
    @Unique
    public final BlendCache betterBiomeBlend$blendColorCache = new BlendCache(1024);
    @Unique
    public final ColorCache betterBiomeBlend$chunkColorCache = new ColorCache(1024);
    @Unique
    private final ThreadLocal<LocalCache> betterBiomeBlend$threadLocalCache = ThreadLocal.withInitial(LocalCache::new);

    protected MixinClientWorld(WritableLevelData writableLevelData, ResourceKey<Level> resourceKey, RegistryAccess registryAccess, Holder<DimensionType> holder, Supplier<ProfilerFiller> supplier, boolean bl, boolean bl2, long l, int i) {
        super(writableLevelData, resourceKey, registryAccess, holder, supplier, bl, bl2, l, i);
    }

    @Inject(method={"clearTintCaches"}, at={@At(value="HEAD")})
    public void onClearColorCaches(CallbackInfo ci) {
        this.betterBiomeBlend$blendColorCache.invalidateAll();
        int blendRadius = BetterBiomeBlendClient.getBiomeBlendRadius();
        this.betterBiomeBlend$chunkColorCache.invalidateAll(blendRadius);
    }

    @Inject(method={"onChunkLoaded"}, at={@At(value="HEAD")})
    public void onOnChunkLoaded(ChunkPos chunkPos, CallbackInfo ci) {
        int chunkX = chunkPos.f_45578_;
        int chunkZ = chunkPos.f_45579_;
        this.betterBiomeBlend$blendColorCache.invalidateChunk(chunkX, chunkZ);
    }

    @Inject(method={"getBlockTint"}, at={@At(value="HEAD")}, cancellable=true)
    public void getBlockTint(BlockPos blockPosIn, ColorResolver colorResolverIn, CallbackInfoReturnable<Integer> cir) {
        int index;
        int color;
        int colorType;
        int x = blockPosIn.m_123341_();
        int y = blockPosIn.m_123342_();
        int z = blockPosIn.m_123343_();
        int chunkX = x >> 4;
        int chunkY = y >> 4;
        int chunkZ = z >> 4;
        int blockX = x & 0xF;
        int blockY = y & 0xF;
        int blockZ = z & 0xF;
        LocalCache localCache = this.betterBiomeBlend$threadLocalCache.get();
        BlendChunk chunk = null;
        if (localCache.lastColorResolver == colorResolverIn) {
            colorType = localCache.lastColorType;
            key = ColorCaching.getChunkKey(chunkX, chunkY, chunkZ, colorType);
            if (localCache.lastBlendChunk.key == key) {
                chunk = localCache.lastBlendChunk;
            }
        } else {
            if (colorResolverIn == BiomeColors.f_108789_) {
                colorType = 0;
            } else if (colorResolverIn == BiomeColors.f_108791_) {
                colorType = 1;
            } else if (colorResolverIn == BiomeColors.f_108790_) {
                colorType = 2;
            } else {
                colorType = CustomColorResolverCompatibility.getColorType(colorResolverIn);
                if (colorType >= localCache.blendChunkCount) {
                    localCache.growBlendChunkArray(colorType);
                }
            }
            key = ColorCaching.getChunkKey(chunkX, chunkY, chunkZ, colorType);
            BlendChunk cachedChunk = localCache.blendChunks[colorType];
            if (cachedChunk.key == key) {
                chunk = cachedChunk;
            }
        }
        Debug.countThreadLocalChunk(chunk);
        if (chunk == null) {
            chunk = this.betterBiomeBlend$blendColorCache.getOrInitChunk(chunkX, chunkY, chunkZ, colorType);
            localCache.putChunk(this.betterBiomeBlend$blendColorCache, chunk, colorType, colorResolverIn);
        }
        if ((color = chunk.data[index = ColorCaching.getArrayIndex(16, blockX, blockY, blockZ)]) == 0) {
            ColorBlending.generateColors(this, colorResolverIn, colorType, this.betterBiomeBlend$chunkColorCache, chunk, x, y, z);
            color = chunk.data[index];
        }
        cir.setReturnValue((Object)color);
    }
}

