/*
 * Decompiled with CFR 0.152.
 */
package net.ddns.vcccd;

import java.util.List;
import java.util.Random;
import net.ddns.vcccd.Main;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.entity.Enderman;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class DrStrangeEvents
implements Listener {
    private final Main main;

    public DrStrangeEvents(Main main) {
        this.main = main;
    }

    private void spawnExperienceOrbs(Location location, int totalOrbs, int expPerOrb) {
        World world = location.getWorld();
        int i = 0;
        while (i < totalOrbs) {
            ExperienceOrb orb = (ExperienceOrb)world.spawn(location, ExperienceOrb.class);
            orb.setExperience(expPerOrb);
            ++i;
        }
    }

    @EventHandler
    public void onDrStrangeAttack(EntityDamageByEntityEvent event) {
        try {
            Enderman drStrange = (Enderman)event.getDamager();
            boolean isDrStrange = drStrange.getCustomName().equals(String.valueOf(ChatColor.DARK_PURPLE) + "Dr. Strange");
            if (isDrStrange) {
                Random rand = new Random();
                Player player = (Player)event.getEntity();
                Location playerLocal = player.getLocation();
                Location randomLocal = new Location(event.getDamager().getWorld(), playerLocal.getX() + (double)rand.nextInt(50), playerLocal.getY(), playerLocal.getZ() + (double)rand.nextInt(50));
                Location highestBlock = player.getWorld().getHighestBlockAt(randomLocal).getLocation();
                highestBlock.setY(highestBlock.getY() + 1.0);
                Location enderLocation = highestBlock;
                enderLocation.setX(enderLocation.getX() + 5.0);
                Location newHighestBlock = playerLocal.getWorld().getHighestBlockAt(enderLocation).getLocation();
                newHighestBlock.setY(newHighestBlock.getY() + 1.0);
                player.teleport(highestBlock);
                event.getDamager().teleport(newHighestBlock);
                player.playSound(player.getLocation(), Sound.ENTITY_ENDERMAN_TELEPORT, 100.0f, 1.0f);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @EventHandler
    public void onDrStrangeDeath(EntityDeathEvent event) {
        if (event.getEntity() instanceof Enderman && event.getEntity().getCustomName().equals(String.valueOf(ChatColor.DARK_PURPLE) + "Dr. Strange")) {
            ItemStack timeStone = new ItemStack(Material.EMERALD);
            ItemMeta timeMeta = timeStone.getItemMeta();
            timeMeta.setDisplayName(String.valueOf(ChatColor.GREEN) + "Time Stone");
            timeMeta.setLore(List.of(String.valueOf(ChatColor.GRAY) + "A powerful stone that controls time.", ChatColor.translateAlternateColorCodes((char)'&', (String)"&eRight-click &7to slow down time for nearby entities."), ChatColor.translateAlternateColorCodes((char)'&', (String)"&eRight-click &7on blocks to speed up growth."), ChatColor.translateAlternateColorCodes((char)'&', (String)"&eShift + Right-click &7on entities to toggle their age.")));
            timeStone.setItemMeta(timeMeta);
            event.getEntity().getWorld().dropItemNaturally(event.getEntity().getLocation(), timeStone);
            this.spawnExperienceOrbs(event.getEntity().getLocation(), 100, 2);
            if (this.main.getConfig().getBoolean("AnnounceBossKill")) {
                for (Player player : this.main.getServer().getOnlinePlayers()) {
                    player.sendMessage(this.main.getPluginPrefix() + "Dr. Strange has been slain!");
                    player.playSound(player.getLocation(), Sound.ENTITY_PLAYER_LEVELUP, 1.0f, 0.0f);
                }
            }
        }
    }
}

