/*
 * Decompiled with CFR 0.152.
 */
package net.ddns.vcccd;

import net.ddns.vcccd.AlbertEntity;
import net.ddns.vcccd.BartholomewEntity;
import net.ddns.vcccd.BigBoyEntity;
import net.ddns.vcccd.DrStrangeEntity;
import net.ddns.vcccd.GortEntity;
import net.ddns.vcccd.Main;
import net.ddns.vcccd.OswaldoEntity;
import net.ddns.vcccd.PiggyEntity;
import net.ddns.vcccd.TimmothyEntity;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Egg;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerEggThrowEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class EggEvents
implements Listener {
    private final Main main;

    public EggEvents(Main main) {
        this.main = main;
    }

    private void spawnEffect(Location loc, World world) {
        world.spawnParticle(Particle.CLOUD, loc, 30);
        world.playSound(loc, Sound.ENTITY_VILLAGER_HURT, 1.0f, 0.0f);
    }

    @EventHandler
    public void onBossEggSpawn(PlayerEggThrowEvent event) {
        Egg eggInQuestion = event.getEgg();
        Player player = event.getPlayer();
        ItemStack eggItem = event.getEgg().getItem();
        if (eggItem == null || !eggItem.hasItemMeta()) {
            return;
        }
        ItemMeta meta = eggItem.getItemMeta();
        if (!meta.hasDisplayName()) {
            return;
        }
        String displayName = ChatColor.stripColor((String)meta.getDisplayName());
        Location loc = eggInQuestion.getLocation();
        World world = eggInQuestion.getWorld();
        FileConfiguration config = this.main.getConfig();
        switch (displayName.toLowerCase()) {
            case "oswaldo egg": {
                new OswaldoEntity(config.getInt("OswaldoHealth"), loc, world, this.main);
                player.sendMessage(this.main.getPluginPrefix() + "You have spawned Oswaldo!");
                this.spawnEffect(loc, world);
                event.setHatching(false);
                break;
            }
            case "bigboy egg": {
                new BigBoyEntity(config.getInt("BigBoyHealth"), loc, world, this.main);
                player.sendMessage(this.main.getPluginPrefix() + "You have spawned BigBoy!");
                this.spawnEffect(loc, world);
                event.setHatching(false);
                break;
            }
            case "timmothy egg": {
                new TimmothyEntity(config.getInt("TimmothyHealth"), loc, world, this.main);
                player.sendMessage(this.main.getPluginPrefix() + "You have spawned Timmothy!");
                this.spawnEffect(loc, world);
                event.setHatching(false);
                break;
            }
            case "albert egg": {
                new AlbertEntity(config.getInt("AlbertHealth"), loc, world);
                player.sendMessage(this.main.getPluginPrefix() + "You have spawned Albert!");
                this.spawnEffect(loc, world);
                event.setHatching(false);
                break;
            }
            case "bartholomew egg": {
                new BartholomewEntity(config.getInt("BartholomewHealth"), loc, world, this.main);
                player.sendMessage(this.main.getPluginPrefix() + "You have spawned Bartholomew!");
                this.spawnEffect(loc, world);
                event.setHatching(false);
                break;
            }
            case "dr. strange egg": {
                new DrStrangeEntity(config.getInt("DrStrangeHealth"), loc, world, this.main);
                player.sendMessage(this.main.getPluginPrefix() + "You have spawned Dr. Strange!");
                this.spawnEffect(loc, world);
                event.setHatching(false);
                break;
            }
            case "gort egg": {
                new GortEntity(config.getInt("GortHealth"), loc, world, this.main);
                player.sendMessage(this.main.getPluginPrefix() + "You have spawned Gort!");
                this.spawnEffect(loc, world);
                event.setHatching(false);
                break;
            }
            case "piggy egg": {
                new PiggyEntity(config.getInt("PiggyHealth"), loc, world, this.main);
                player.sendMessage(this.main.getPluginPrefix() + "You have spawned Piggy!");
                this.spawnEffect(loc, world);
                event.setHatching(false);
                break;
            }
            default: {
                player.sendMessage(this.main.getPluginPrefix() + "Unknown boss egg!");
            }
        }
    }
}

