/*
 * Decompiled with CFR 0.152.
 */
package net.ddns.vcccd;

import java.util.Collection;
import net.ddns.vcccd.Main;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.block.Block;
import org.bukkit.block.data.Ageable;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class TimeStoneEvents
implements Listener {
    private final Main main;
    private int radius;
    private int duration;
    private int numParticles;

    public TimeStoneEvents(Main main) {
        this.main = main;
        this.radius = main.getConfig().getInt("radius");
        this.duration = main.getConfig().getInt("duration");
        this.numParticles = main.getConfig().getInt("numParticles");
    }

    @EventHandler
    public void generalTimeStoneUse(PlayerInteractEvent event) {
        try {
            boolean isRightClick;
            Player player = event.getPlayer();
            PlayerInventory inventory = player.getInventory();
            Action eventAction = event.getAction();
            boolean isHoldingTimeStone = inventory.getItemInMainHand().getItemMeta().getDisplayName().equals(String.valueOf(ChatColor.GREEN) + "Time Stone");
            boolean cooldownComplete = player.getCooldown(Material.EMERALD) == 0;
            boolean bl = isRightClick = eventAction == Action.RIGHT_CLICK_BLOCK || eventAction == Action.RIGHT_CLICK_AIR;
            if (cooldownComplete && isHoldingTimeStone && isRightClick) {
                this.slowTime(player);
                Block clickedBlock = event.getClickedBlock();
                try {
                    Ageable blockData = (Ageable)clickedBlock.getBlockData();
                    blockData.setAge(7);
                    clickedBlock.setBlockData((BlockData)blockData);
                    Location blockLocation = clickedBlock.getLocation();
                    int i = 0;
                    while (i < 10) {
                        player.getWorld().spawnParticle(Particle.HAPPY_VILLAGER, blockLocation.getX() + Math.random(), blockLocation.getY() + Math.random(), blockLocation.getZ() + Math.random(), 3);
                        ++i;
                    }
                    player.setCooldown(Material.EMERALD, 100);
                }
                catch (Exception exception) {}
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @EventHandler
    public void entityInteract(PlayerInteractEntityEvent event) {
        try {
            if (event.getHand() != EquipmentSlot.HAND) {
                return;
            }
            Player player = event.getPlayer();
            PlayerInventory inventory = player.getInventory();
            boolean isHoldingTimeStone = inventory.getItemInMainHand().getItemMeta().getDisplayName().equals(String.valueOf(ChatColor.GREEN) + "Time Stone");
            boolean cooldownComplete = player.getCooldown(Material.EMERALD) == 0;
            boolean isTargetAgeable = event.getRightClicked() instanceof org.bukkit.entity.Ageable;
            if (player.isSneaking() && isHoldingTimeStone && cooldownComplete && isTargetAgeable) {
                org.bukkit.entity.Ageable target = (org.bukkit.entity.Ageable)event.getRightClicked();
                if (target.isAdult()) {
                    target.setBaby();
                } else {
                    target.setAdult();
                }
                Location loc = target.getLocation();
                int i = 0;
                while (i < 10) {
                    player.getWorld().spawnParticle(Particle.HAPPY_VILLAGER, loc.getX() + (Math.random() - 0.5), loc.getY() + Math.random(), loc.getZ() + (Math.random() - 0.5), 3);
                    ++i;
                }
                player.setCooldown(Material.EMERALD, 100);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void slowTime(Player player) {
        double angle = Math.PI * 2 / (double)this.numParticles;
        Location playerLoc = player.getLocation();
        int i = 0;
        while (i < this.numParticles) {
            double offsetX = (double)this.radius * Math.cos(angle * (double)i);
            double offsetZ = (double)this.radius * Math.sin(angle * (double)i);
            player.getWorld().spawnParticle(Particle.HAPPY_VILLAGER, playerLoc.getX() + offsetX, playerLoc.getY(), playerLoc.getZ() + offsetZ, 3);
            ++i;
        }
        Collection nearbyEntities = player.getWorld().getNearbyEntities(playerLoc, (double)this.radius, (double)this.radius, (double)this.radius);
        for (Entity entity : nearbyEntities) {
            try {
                if (!(entity instanceof LivingEntity) || entity.equals(player)) continue;
                LivingEntity target = (LivingEntity)entity;
                target.addPotionEffect(new PotionEffect(PotionEffectType.SLOWNESS, this.duration, 3));
                target.addPotionEffect(new PotionEffect(PotionEffectType.GLOWING, this.duration, 1));
                target.addPotionEffect(new PotionEffect(PotionEffectType.SLOW_FALLING, this.duration, 3));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        player.setCooldown(Material.EMERALD, 100);
    }
}

