/*
 * Decompiled with CFR 0.152.
 */
package net.ddns.vcccd;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import net.ddns.vcccd.Main;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.World;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.boss.BossBar;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Mob;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.plugin.Plugin;

public class BossBars
implements CommandExecutor,
Listener {
    private final Main main;
    private final Map<UUID, BossBar> activeBossBars = new HashMap<UUID, BossBar>();
    private static final Map<String, BossProperties> BOSS_DATA = new HashMap<String, BossProperties>();

    public BossBars(Main main) {
        this.main = main;
        Bukkit.getScheduler().runTaskTimer((Plugin)main, () -> {
            Iterator<Map.Entry<UUID, BossBar>> it = this.activeBossBars.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<UUID, BossBar> entry = it.next();
                Entity e = Bukkit.getEntity((UUID)entry.getKey());
                if (e != null && !e.isDead()) continue;
                entry.getValue().removeAll();
                it.remove();
            }
        }, 0L, 20L);
        Bukkit.getScheduler().runTaskTimer((Plugin)main, this::proximityWatcher, 0L, 5L);
    }

    private void proximityWatcher() {
        FileConfiguration config = this.main.getConfig();
        double PROXIMITY_RADIUS = 40.0;
        for (World world : Bukkit.getWorlds()) {
            for (Entity entity : world.getEntities()) {
                BossProperties props;
                String name = entity.getCustomName();
                if (name == null || !(entity instanceof Mob) || (props = BOSS_DATA.get(name)) == null) continue;
                Mob mob = (Mob)entity;
                UUID bossId = entity.getUniqueId();
                BossBar bar = this.activeBossBars.computeIfAbsent(bossId, id -> {
                    double maxHealth = config.getDouble(props.configKey, props.defaultHealth);
                    mob.setMaxHealth(maxHealth);
                    return Bukkit.createBossBar((String)name, (BarColor)props.color, (BarStyle)BarStyle.SOLID, (BarFlag[])new BarFlag[0]);
                });
                double maxHealth = mob.getMaxHealth();
                double currentHealth = mob.getHealth();
                double progress = currentHealth / maxHealth;
                bar.setProgress(Math.max(0.0, Math.min(1.0, progress)));
                bar.setTitle(name);
                for (Player player : Bukkit.getOnlinePlayers()) {
                    if (player.getWorld().equals((Object)entity.getWorld())) {
                        double distance = player.getLocation().distance(entity.getLocation());
                        if (distance <= 40.0) {
                            if (bar.getPlayers().contains(player)) continue;
                            bar.addPlayer(player);
                            bar.setVisible(true);
                            continue;
                        }
                        if (!bar.getPlayers().contains(player)) continue;
                        bar.removePlayer(player);
                        continue;
                    }
                    if (!bar.getPlayers().contains(player)) continue;
                    bar.removePlayer(player);
                }
            }
        }
    }

    @EventHandler
    public void onEntityDamage(EntityDamageByEntityEvent event) {
    }

    @EventHandler
    public void onEntityDeath(EntityDeathEvent event) {
        BossBar bar = this.activeBossBars.remove(event.getEntity().getUniqueId());
        if (bar != null) {
            bar.removeAll();
        }
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (sender instanceof Player) {
            for (BossBar bar : this.activeBossBars.values()) {
                bar.removeAll();
            }
            this.activeBossBars.clear();
            sender.sendMessage(this.main.getPluginPrefix() + "All boss bars removed.");
        }
        return true;
    }

    static {
        BOSS_DATA.put(ChatColor.translateAlternateColorCodes((char)'&', (String)"&eAlbert"), new BossProperties("AlbertHealth", 16.0, BarColor.YELLOW));
        BOSS_DATA.put(ChatColor.translateAlternateColorCodes((char)'&', (String)"&c&lOswaldo"), new BossProperties("OswaldoHealth", 300.0, BarColor.RED));
        BOSS_DATA.put(ChatColor.translateAlternateColorCodes((char)'&', (String)"&c&lBig Boy"), new BossProperties("BigBoyHealth", 300.0, BarColor.WHITE));
        BOSS_DATA.put(String.valueOf(ChatColor.AQUA) + "Timmothy", new BossProperties("TimmothyHealth", 300.0, BarColor.BLUE));
        BOSS_DATA.put(String.valueOf(ChatColor.BLACK) + "Bartholomew", new BossProperties("BartholomewHealth", 300.0, BarColor.PURPLE));
        BOSS_DATA.put(ChatColor.translateAlternateColorCodes((char)'&', (String)"&c&lPiGgY"), new BossProperties("PiggyHealth", 300.0, BarColor.PINK));
        BOSS_DATA.put(String.valueOf(ChatColor.DARK_PURPLE) + "Dr. Strange", new BossProperties("DrStrangeHealth", 300.0, BarColor.PURPLE));
        BOSS_DATA.put(ChatColor.translateAlternateColorCodes((char)'&', (String)"&eGort The Serf"), new BossProperties("GortHealth", 30.0, BarColor.YELLOW));
    }

    private static class BossProperties {
        public final String configKey;
        public final double defaultHealth;
        public final BarColor color;

        public BossProperties(String configKey, double defaultHealth, BarColor color) {
            this.configKey = configKey;
            this.defaultHealth = defaultHealth;
            this.color = color;
        }
    }
}

