/*
 * Decompiled with CFR 0.152.
 */
package net.ddns.vcccd;

import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.ddns.vcccd.Main;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.entity.Enderman;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class DrStrangeEvents
implements Listener {
    private final Main main;

    public DrStrangeEvents(Main main) {
        this.main = main;
    }

    private void spawnExperienceOrbs(Location location, int totalOrbs, int expPerOrb) {
        World world = location.getWorld();
        for (int i = 0; i < totalOrbs; ++i) {
            ExperienceOrb orb = (ExperienceOrb)world.spawn(location, ExperienceOrb.class);
            orb.setExperience(expPerOrb);
        }
    }

    @EventHandler
    public void onDrStrangeAttack(EntityDamageByEntityEvent event) {
        try {
            Location targetLoc;
            Player targetPlayer;
            if (!(event.getDamager() instanceof Enderman)) {
                return;
            }
            Enderman drStrange = (Enderman)event.getDamager();
            if (!(String.valueOf(ChatColor.DARK_PURPLE) + "Dr. Strange").equals(drStrange.getCustomName())) {
                return;
            }
            if (this.main.getConfig().getBoolean("DrStrangeAngryAtClosestPlayer")) {
                double closestDistance = Double.MAX_VALUE;
                Player closest = null;
                for (Player p : drStrange.getWorld().getPlayers()) {
                    double dist = p.getLocation().distance(drStrange.getLocation());
                    if (!(dist < closestDistance)) continue;
                    closestDistance = dist;
                    closest = p;
                }
                targetPlayer = closest;
            } else {
                if (!(event.getEntity() instanceof Player)) {
                    return;
                }
                targetPlayer = (Player)event.getEntity();
            }
            if (targetPlayer == null) {
                return;
            }
            Random rand = new Random();
            int radiusX = this.main.getConfig().getInt("TeleportAllowedRadius.x", 15);
            int radiusY = this.main.getConfig().getInt("TeleportAllowedRadius.y", 2);
            int radiusZ = this.main.getConfig().getInt("TeleportAllowedRadius.z", 15);
            List blockList = this.main.getConfig().getStringList("DrStrangeTeleportBlockType");
            HashSet<Material> allowedBlocks = new HashSet<Material>();
            boolean allowAllBlocks = false;
            for (String s : blockList) {
                if (s.equalsIgnoreCase("minecraft:*") || s.equals("*")) {
                    allowAllBlocks = true;
                    break;
                }
                try {
                    Material m = Material.matchMaterial((String)s.replace("minecraft:", ""));
                    if (m == null) continue;
                    allowedBlocks.add(m);
                }
                catch (Exception exception) {}
            }
            if ((targetLoc = this.findSafeLocation(targetPlayer.getWorld(), targetPlayer.getLocation(), radiusX, radiusY, radiusZ, rand, allowedBlocks, allowAllBlocks)) != null) {
                targetPlayer.teleport(targetLoc);
                drStrange.teleport(targetLoc.clone().add(1.0, 0.0, 0.0));
                targetPlayer.playSound(targetPlayer.getLocation(), Sound.ENTITY_ENDERMAN_TELEPORT, 1.0f, 1.0f);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private Location findSafeLocation(World world, Location base, int radiusX, int radiusY, int radiusZ, Random rand, Set<Material> allowedBlocks, boolean allowAllBlocks) {
        for (int i = 0; i < 20; ++i) {
            double offsetX = rand.nextInt(radiusX * 2 + 1) - radiusX;
            double offsetY = rand.nextInt(radiusY * 2 + 1) - radiusY;
            double offsetZ = rand.nextInt(radiusZ * 2 + 1) - radiusZ;
            Location blockBelowLoc = base.clone().add(offsetX, offsetY, offsetZ);
            if (blockBelowLoc.getY() <= 0.0) continue;
            Material blockType = blockBelowLoc.getBlock().getType();
            if (!allowAllBlocks && !allowedBlocks.contains(blockType)) continue;
            return blockBelowLoc.clone().add(0.0, 1.0, 0.0);
        }
        return null;
    }

    @EventHandler
    public void onDrStrangeDeath(EntityDeathEvent event) {
        if (event.getEntity() instanceof Enderman && (String.valueOf(ChatColor.DARK_PURPLE) + "Dr. Strange").equals(event.getEntity().getCustomName())) {
            ItemStack timeStone = new ItemStack(Material.EMERALD);
            ItemMeta timeMeta = timeStone.getItemMeta();
            timeMeta.setDisplayName(String.valueOf(ChatColor.GREEN) + "Time Stone");
            timeMeta.setLore(List.of(String.valueOf(ChatColor.GRAY) + "A powerful stone that controls time.", ChatColor.translateAlternateColorCodes((char)'&', (String)"&eRight-click &7to slow down time for nearby entities."), ChatColor.translateAlternateColorCodes((char)'&', (String)"&eRight-click &7on blocks to speed up growth."), ChatColor.translateAlternateColorCodes((char)'&', (String)"&eShift + Right-click &7on entities to toggle their age.")));
            timeStone.setItemMeta(timeMeta);
            event.getEntity().getWorld().dropItemNaturally(event.getEntity().getLocation(), timeStone);
            this.spawnExperienceOrbs(event.getEntity().getLocation(), 100, 2);
            if (this.main.getConfig().getBoolean("AnnounceBossKill")) {
                for (Player player : this.main.getServer().getOnlinePlayers()) {
                    player.sendMessage(this.main.getPluginPrefix() + "Dr. Strange has been slain!");
                    player.playSound(player.getLocation(), Sound.ENTITY_PLAYER_LEVELUP, 1.0f, 0.0f);
                }
            }
        }
    }
}

