/*
 * Decompiled with CFR 0.152.
 */
package net.ddns.vcccd;

import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.extent.clipboard.Clipboard;
import com.sk89q.worldedit.extent.clipboard.io.ClipboardFormat;
import com.sk89q.worldedit.extent.clipboard.io.ClipboardFormats;
import com.sk89q.worldedit.extent.clipboard.io.ClipboardReader;
import com.sk89q.worldedit.function.operation.Operation;
import com.sk89q.worldedit.function.operation.Operations;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.session.ClipboardHolder;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import java.util.function.Supplier;
import net.ddns.vcccd.BartholomewEntity;
import net.ddns.vcccd.DrStrangeEntity;
import net.ddns.vcccd.GortEntity;
import net.ddns.vcccd.Main;
import net.ddns.vcccd.OswaldoEntity;
import net.ddns.vcccd.PiggyEntity;
import net.ddns.vcccd.TimmothyEntity;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.world.ChunkLoadEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class GenerateStructures
implements Listener {
    private final Set<String> pastedChunks = new HashSet<String>();
    private final Main plugin;
    private int random = new Random().nextInt(1000);

    public GenerateStructures(Main plugin) {
        this.plugin = plugin;
    }

    public boolean allBlocksNotAir(Chunk chunk) {
        World world = chunk.getWorld();
        int chunkX = chunk.getX() << 4;
        int chunkZ = chunk.getZ() << 4;
        for (int x = 0; x < 12; ++x) {
            for (int z = 0; z < 12; ++z) {
                int worldX = chunkX + x;
                int worldZ = chunkZ + z;
                int worldY = world.getHighestBlockYAt(worldX, worldZ);
                Block block = world.getBlockAt(worldX, worldY - 1, worldZ);
                Material type = block.getType();
                if (type != Material.AIR && type != Material.WATER) continue;
                return false;
            }
        }
        return true;
    }

    @EventHandler
    public void onChunkLoad(ChunkLoadEvent event) {
        if (!this.plugin.getConfig().getBoolean("GenerateStructures", true)) {
            return;
        }
        final Chunk chunk = event.getChunk();
        final World world = chunk.getWorld();
        int chunkX = chunk.getX();
        int chunkZ = chunk.getZ();
        String key = world.getName() + ":" + chunkX + ":" + chunkZ;
        if (this.pastedChunks.contains(key)) {
            return;
        }
        this.pastedChunks.add(key);
        final int pasteX = chunkX << 4;
        final int pasteZ = chunkZ << 4;
        final int pasteY = world.getHighestBlockYAt(chunk.getBlock(0, 0, 0).getLocation());
        new BukkitRunnable(this){
            final /* synthetic */ GenerateStructures this$0;
            {
                this.this$0 = this$0;
            }

            public void run() {
                if (this.this$0.allBlocksNotAir(chunk)) {
                    switch (new Random().nextInt(6)) {
                        case 0: {
                            File oswaldoSchematicFile = new File("plugins/MoreBosses/structures/GeneratedTower.schem");
                            this.this$0.pasteSchematic(world, pasteX, pasteY, pasteZ, oswaldoSchematicFile, () -> new OswaldoEntity(this.this$0.plugin.getConfig().getInt("OswaldoHealth"), new Location(world, (double)pasteX, (double)(pasteY + 2), (double)pasteZ), world, this.this$0.plugin));
                            break;
                        }
                        case 1: {
                            File timmothySchematicFile = new File("plugins/MoreBosses/structures/TimmothyHut.schem");
                            this.this$0.pasteSchematic(world, pasteX, pasteY, pasteZ, timmothySchematicFile, () -> new TimmothyEntity(this.this$0.plugin.getConfig().getInt("TimmothyHealth"), new Location(world, (double)pasteX, (double)(pasteY + 2), (double)pasteZ), world, this.this$0.plugin));
                            break;
                        }
                        case 2: {
                            File bartholomewSchematicFile = new File("plugins/MoreBosses/structures/BartTower.schem");
                            this.this$0.pasteSchematic(world, pasteX, pasteY, pasteZ, bartholomewSchematicFile, () -> new BartholomewEntity(this.this$0.plugin.getConfig().getInt("BartholomewHealth"), new Location(world, (double)pasteX, (double)(pasteY + 2), (double)pasteZ), world, this.this$0.plugin));
                            break;
                        }
                        case 3: {
                            File piggySchematicFile = new File("plugins/MoreBosses/structures/PiggyPin.schem");
                            this.this$0.pasteSchematic(world, pasteX, pasteY, pasteZ, piggySchematicFile, () -> new PiggyEntity(this.this$0.plugin.getConfig().getInt("PiggyHealth"), new Location(world, (double)pasteX, (double)(pasteY + 2), (double)pasteZ), world, this.this$0.plugin));
                            break;
                        }
                        case 4: {
                            File gortSchematicFile = new File("plugins/MoreBosses/structures/GortHouse.schem");
                            this.this$0.pasteSchematic(world, pasteX, pasteY, pasteZ, gortSchematicFile, () -> new GortEntity(this.this$0.plugin.getConfig().getInt("GortHealth"), new Location(world, (double)pasteX, (double)(pasteY + 2), (double)pasteZ), world, this.this$0.plugin));
                            break;
                        }
                        case 5: {
                            File drStrangeSchematicFile = new File("plugins/MoreBosses/structures/StrangeLibrary.schem");
                            this.this$0.pasteSchematic(world, pasteX, pasteY, pasteZ, drStrangeSchematicFile, () -> new DrStrangeEntity(this.this$0.plugin.getConfig().getInt("DrStrangeHealth"), new Location(world, (double)pasteX, (double)(pasteY + 2), (double)pasteZ), world, this.this$0.plugin));
                            break;
                        }
                    }
                }
            }
        }.runTaskLater((Plugin)this.plugin, 1L);
    }

    private void pasteSchematic(World world, final int x, final int y, final int z, File schematicFile, final Supplier<?> bossSpawner) {
        ClipboardFormat format = ClipboardFormats.findByFile((File)schematicFile);
        if (format == null) {
            Bukkit.getLogger().warning("Unsupported schematic format.");
            return;
        }
        try (ClipboardReader reader = format.getReader((InputStream)new FileInputStream(schematicFile));){
            if (new Random().nextInt(this.plugin.getConfig().getInt("SpawnFrequency") * 100) == 1) {
                Clipboard clipboard = reader.read();
                this.plugin.getConsole().sendMessage("Attempting to paste schematic at " + x + ", " + (y + 1) + ", " + z);
                EditSession editSession = WorldEdit.getInstance().newEditSessionBuilder().world(BukkitAdapter.adapt((World)world)).build();
                Operation operation = new ClipboardHolder(clipboard).createPaste((Extent)editSession).to(BlockVector3.at((int)x, (int)(y + 1), (int)z)).ignoreAirBlocks(false).build();
                Operations.complete((Operation)operation);
                editSession.flushSession();
                this.plugin.getConsole().sendMessage("Building pasted.");
                new BukkitRunnable(this){
                    final /* synthetic */ GenerateStructures this$0;
                    {
                        this.this$0 = this$0;
                    }

                    public void run() {
                        try {
                            bossSpawner.get();
                            this.this$0.plugin.getConsole().sendMessage("Boss spawned at " + x + ", " + (y + 2) + ", " + z);
                        }
                        catch (Exception ex) {
                            this.this$0.plugin.getConsole().sendMessage("Boss spawn failed: " + ex.getMessage());
                            ex.printStackTrace();
                        }
                    }
                }.runTaskLater((Plugin)this.plugin, 10L);
            }
        }
        catch (WorldEditException | IOException e) {
            e.printStackTrace();
        }
    }
}

