/*
 * Decompiled with CFR 0.152.
 */
package net.ddns.vcccd;

import java.util.Random;
import net.ddns.vcccd.BartholomewEntity;
import net.ddns.vcccd.BigBoyEntity;
import net.ddns.vcccd.DrStrangeEntity;
import net.ddns.vcccd.GortEntity;
import net.ddns.vcccd.Main;
import net.ddns.vcccd.OswaldoEntity;
import net.ddns.vcccd.PiggyEntity;
import net.ddns.vcccd.TimmothyEntity;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.world.ChunkLoadEvent;

public class SpawnInWorld
implements Listener {
    private final Main main;
    private FileConfiguration config;

    public SpawnInWorld(Main main) {
        this.main = main;
        this.config = main.getConfig();
    }

    private int RNG(int scope) {
        return new Random().nextInt(28 + scope);
    }

    @EventHandler
    public void onChunkLoad(ChunkLoadEvent event) {
        if (this.main.getConfig().getBoolean("SpawnInWorld")) {
            String[] worldReference;
            Chunk chunk = event.getChunk();
            World chunkWorld = chunk.getWorld();
            String[] stringArray = worldReference = this.config.getString("Worlds").split(",");
            int n = worldReference.length;
            int n2 = 0;
            while (n2 < n) {
                String worldName = stringArray[n2];
                if (worldName.equals(chunkWorld.getName())) {
                    int x = chunk.getX() * 16 + (int)(Math.random() * 16.0);
                    int z = chunk.getZ() * 16 + (int)(Math.random() * 16.0);
                    int y = chunk.getWorld().getHighestBlockYAt(x, z) + 4;
                    Location spawnLocation = new Location(chunkWorld, (double)x, (double)y, (double)z);
                    switch (this.RNG(this.config.getInt("SpawnRNG"))) {
                        case 1: {
                            if (!this.config.getBoolean("OswaldoSpawn")) break;
                            new OswaldoEntity(this.config.getInt("OswaldoHealth"), spawnLocation, chunkWorld, this.main);
                            break;
                        }
                        case 2: {
                            if (!this.config.getBoolean("BigBoySpawn")) break;
                            new BigBoyEntity(this.config.getInt("BigBoyHealth"), spawnLocation, chunkWorld, this.main);
                            break;
                        }
                        case 3: {
                            if (!this.config.getBoolean("TimmothySpawn")) break;
                            new TimmothyEntity(this.config.getInt("TimmothySpawn"), spawnLocation, chunkWorld, this.main);
                            break;
                        }
                        case 4: {
                            if (!this.config.getBoolean("BartholomewSpawn")) break;
                            new BartholomewEntity(this.config.getInt("BartholomewHealth"), spawnLocation, chunkWorld, this.main);
                            break;
                        }
                        case 5: {
                            if (!this.config.getBoolean("PiggySpawn")) break;
                            new PiggyEntity(this.config.getInt("PiggyHealth"), spawnLocation, chunkWorld, this.main);
                            break;
                        }
                        case 6: {
                            if (!this.config.getBoolean("GortSpawn")) break;
                            new GortEntity(this.config.getInt("GortHealth"), spawnLocation, chunkWorld, this.main);
                            break;
                        }
                        case 7: {
                            if (!this.config.getBoolean("DrStrangeSpawn")) break;
                            new DrStrangeEntity(this.config.getInt("DrStrangeHealth"), spawnLocation, chunkWorld, this.main);
                        }
                    }
                }
                ++n2;
            }
        }
    }
}

