/*
 * Decompiled with CFR 0.152.
 */
package net.ddns.vcccd;

import net.ddns.vcccd.AlbertEntity;
import net.ddns.vcccd.Main;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.entity.Player;
import org.bukkit.entity.Slime;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDeathEvent;

public class AlbertEvents
implements Listener {
    private final Main main;

    public AlbertEvents(Main main) {
        this.main = main;
    }

    private void spawnExperienceOrbs(Location location, int totalOrbs, int expPerOrb) {
        World world = location.getWorld();
        int i = 0;
        while (i < totalOrbs) {
            ExperienceOrb orb = (ExperienceOrb)world.spawn(location, ExperienceOrb.class);
            orb.setExperience(expPerOrb);
            ++i;
        }
    }

    @EventHandler
    public void onPlayerAttackAlbert(EntityDamageByEntityEvent event) {
        try {
            Slime slime = (Slime)event.getEntity();
            Player player = (Player)event.getDamager();
            if (slime.getCustomName().equals(String.valueOf(ChatColor.YELLOW) + "Albert")) {
                String playerItemName = player.getInventory().getItemInMainHand().getItemMeta().getDisplayName();
                if (!playerItemName.equals(ChatColor.translateAlternateColorCodes((char)'&', (String)"&eAlbert Remover"))) {
                    Location slimeLocation = slime.getLocation();
                    World world = slime.getWorld();
                    new AlbertEntity(32, slimeLocation, world);
                } else {
                    slime.remove();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @EventHandler
    public void onAlbertDeath(EntityDeathEvent event) {
        try {
            Slime piggy = (Slime)event.getEntity();
            boolean isAlbert = piggy.getCustomName().equals(String.valueOf(ChatColor.YELLOW) + "Albert");
            if (isAlbert && this.main.getConfig().getBoolean("AnnounceBossKill")) {
                for (Player player : this.main.getServer().getOnlinePlayers()) {
                    player.sendMessage(this.main.getPluginPrefix() + "Albert has been slain!");
                    player.playSound(player.getLocation(), Sound.ENTITY_PLAYER_LEVELUP, 1.0f, 0.0f);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

