/*
 * Decompiled with CFR 0.152.
 */
package net.ddns.vcccd;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import net.ddns.vcccd.Main;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.boss.BossBar;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Mob;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.plugin.Plugin;

public class BossBars
implements CommandExecutor,
Listener {
    private final Main main;
    private final Map<UUID, BossBar> activeBossBars = new HashMap<UUID, BossBar>();

    public BossBars(Main main) {
        this.main = main;
        Bukkit.getScheduler().runTaskTimer((Plugin)main, () -> {
            Iterator<Map.Entry<UUID, BossBar>> it = this.activeBossBars.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<UUID, BossBar> entry = it.next();
                Entity e = Bukkit.getEntity((UUID)entry.getKey());
                if (e != null && !e.isDead()) continue;
                entry.getValue().removeAll();
                it.remove();
            }
        }, 0L, 20L);
    }

    private void displayBar(Entity entity, double maxHealth, Player player, BarColor color) {
        BossBar bar = this.activeBossBars.computeIfAbsent(entity.getUniqueId(), id -> Bukkit.createBossBar((String)entity.getCustomName(), (BarColor)color, (BarStyle)BarStyle.SOLID, (BarFlag[])new BarFlag[0]));
        double progress = ((Mob)entity).getHealth() / maxHealth;
        bar.setProgress(Math.max(0.0, Math.min(1.0, progress)));
        bar.setVisible(true);
        if (!bar.getPlayers().contains(player)) {
            bar.addPlayer(player);
        }
    }

    @EventHandler
    public void onEntityDamage(EntityDamageByEntityEvent event) {
        if (!(event.getDamager() instanceof Player)) {
            return;
        }
        if (!(event.getEntity() instanceof Mob)) {
            return;
        }
        if (event.getEntity().getCustomName() == null) {
            return;
        }
        Player player = (Player)event.getDamager();
        FileConfiguration config = this.main.getConfig();
        String name = event.getEntity().getCustomName();
        if (name.equals(ChatColor.translateAlternateColorCodes((char)'&', (String)"&eAlbert"))) {
            this.displayBar(event.getEntity(), config.getDouble("AlbertHealth", 16.0), player, BarColor.YELLOW);
        } else if (name.equals(ChatColor.translateAlternateColorCodes((char)'&', (String)"&c&lOswaldo"))) {
            this.displayBar(event.getEntity(), config.getDouble("OswaldoHealth", 300.0), player, BarColor.RED);
        } else if (name.equals(ChatColor.translateAlternateColorCodes((char)'&', (String)"&c&lBig Boy"))) {
            this.displayBar(event.getEntity(), config.getDouble("BigBoyHealth", 300.0), player, BarColor.WHITE);
        } else if (name.equals(String.valueOf(ChatColor.AQUA) + "Timmothy")) {
            this.displayBar(event.getEntity(), config.getDouble("TimmothyHealth", 300.0), player, BarColor.BLUE);
        } else if (name.equals(String.valueOf(ChatColor.BLACK) + "Bartholomew")) {
            this.displayBar(event.getEntity(), config.getDouble("BartholomewHealth", 300.0), player, BarColor.PURPLE);
        } else if (name.equals(ChatColor.translateAlternateColorCodes((char)'&', (String)"&c&lPiGgY"))) {
            this.displayBar(event.getEntity(), config.getDouble("PiggyHealth", 300.0), player, BarColor.PINK);
        } else if (name.equals(String.valueOf(ChatColor.DARK_PURPLE) + "Dr. Strange")) {
            this.displayBar(event.getEntity(), config.getDouble("DrStrangeHealth", 300.0), player, BarColor.PURPLE);
        }
    }

    @EventHandler
    public void onEntityDeath(EntityDeathEvent event) {
        BossBar bar = this.activeBossBars.remove(event.getEntity().getUniqueId());
        if (bar != null) {
            bar.removeAll();
        }
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (sender instanceof Player) {
            for (BossBar bar : this.activeBossBars.values()) {
                bar.removeAll();
            }
            this.activeBossBars.clear();
            sender.sendMessage(this.main.getPluginPrefix() + "All boss bars removed.");
        }
        return true;
    }
}

