/*
 * Decompiled with CFR 0.152.
 */
package net.ddns.vcccd;

import java.util.ArrayList;
import net.ddns.vcccd.Main;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.PigZombie;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class PiggyEvents
implements Listener {
    private ArrayList<Player> PiggyPlayers = new ArrayList();
    private final Main main;

    public PiggyEvents(Main main) {
        this.main = main;
    }

    private ItemStack CustomItem(Material item, String name) {
        ItemStack ReturnItem = new ItemStack(item);
        ItemMeta ReturnItemData = ReturnItem.getItemMeta();
        ReturnItemData.setDisplayName(name);
        ReturnItem.setItemMeta(ReturnItemData);
        return ReturnItem;
    }

    private void DropItemAt(LivingEntity entity, ItemStack item) {
        Location location = entity.getLocation();
        World world = entity.getWorld();
        world.dropItem(location, item);
    }

    private void spawnExperienceOrbs(Location location, int totalOrbs, int expPerOrb) {
        World world = location.getWorld();
        for (int i = 0; i < totalOrbs; ++i) {
            ExperienceOrb orb = (ExperienceOrb)world.spawn(location, ExperienceOrb.class);
            orb.setExperience(expPerOrb);
        }
    }

    @EventHandler
    public void onPiggyAttacked(EntityDamageByEntityEvent event) {
        try {
            boolean isPlayer = event.getDamager() instanceof Player;
            boolean listContainsPlayer = this.PiggyPlayers.contains(event.getDamager());
            if (isPlayer && !listContainsPlayer) {
                this.PiggyPlayers.add((Player)event.getDamager());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @EventHandler
    public void onPlayerNearPiggy(PlayerMoveEvent event) {
        Player player = event.getPlayer();
        for (LivingEntity entity : player.getNearbyEntities(10.0, 10.0, 10.0).stream().filter(e -> e instanceof PigZombie).map(e -> (LivingEntity)e).toList()) {
            if (entity.getCustomName() == null || !entity.getCustomName().equals(ChatColor.translateAlternateColorCodes((char)'&', (String)"&c&lPiGgY"))) continue;
            PigZombie piggy = (PigZombie)entity;
            piggy.setAngry(true);
            piggy.setTarget((LivingEntity)player);
        }
    }

    @EventHandler
    public void onPiggyDeath(EntityDeathEvent event) {
        try {
            boolean isPiggy;
            if (!(event.getEntity() instanceof PigZombie)) {
                return;
            }
            PigZombie piggy = (PigZombie)event.getEntity();
            boolean bl = isPiggy = piggy.getCustomName() != null && piggy.getCustomName().equals(ChatColor.translateAlternateColorCodes((char)'&', (String)"&c&lPiGgY"));
            if (isPiggy) {
                this.DropItemAt(event.getEntity(), this.CustomItem(Material.GOLDEN_AXE, ChatColor.translateAlternateColorCodes((char)'&', (String)"&c&lPiggy&4&lAxe")));
                this.spawnExperienceOrbs(event.getEntity().getLocation(), 100, 2);
                if (this.main.getConfig().getBoolean("AnnounceBossKill")) {
                    for (Player player : this.main.getServer().getOnlinePlayers()) {
                        player.sendMessage(this.main.getPluginPrefix() + "Piggy has been slain!");
                        player.playSound(player.getLocation(), Sound.ENTITY_PLAYER_LEVELUP, 1.0f, 0.0f);
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

