/*
 * Decompiled with CFR 0.152.
 */
package net.ddns.vcccd;

import net.ddns.vcccd.BartholomewEntity;
import net.ddns.vcccd.BigBoyEntity;
import net.ddns.vcccd.DrStrangeEntity;
import net.ddns.vcccd.GortEntity;
import net.ddns.vcccd.Main;
import net.ddns.vcccd.OswaldoEntity;
import net.ddns.vcccd.PiggyEntity;
import net.ddns.vcccd.TimmothyEntity;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;

public class SpawnBossCommand
implements CommandExecutor,
Listener {
    private final Main main;
    private final FileConfiguration config;

    public SpawnBossCommand(Main main) {
        this.main = main;
        this.config = main.getConfig();
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (args.length < 1) {
            sender.sendMessage(this.main.getPluginPrefix() + "Usage: /spawnboss <boss> [player|x y z]");
            return true;
        }
        String bossName = args[0];
        Location spawnLocation = null;
        World world = null;
        if (args.length == 1) {
            if (!(sender instanceof Player)) {
                sender.sendMessage(this.main.getPluginPrefix() + "Only players can use this command without a target.");
                return true;
            }
            player = (Player)sender;
            spawnLocation = player.getLocation();
            world = player.getWorld();
        } else if (args.length == 2) {
            Player target = Bukkit.getPlayer((String)args[1]);
            if (target == null) {
                sender.sendMessage(this.main.getPluginPrefix() + "Player not found.");
                return true;
            }
            spawnLocation = target.getLocation();
            world = target.getWorld();
        } else if (args.length == 4) {
            if (!(sender instanceof Player)) {
                sender.sendMessage(this.main.getPluginPrefix() + "Only players can run this with coordinates.");
                return true;
            }
            player = (Player)sender;
            world = player.getWorld();
            try {
                double x = Double.parseDouble(args[1]);
                double y = Double.parseDouble(args[2]);
                double z = Double.parseDouble(args[3]);
                spawnLocation = new Location(world, x, y, z);
            }
            catch (NumberFormatException e) {
                sender.sendMessage(this.main.getPluginPrefix() + "Invalid coordinates.");
                return true;
            }
        } else {
            sender.sendMessage(this.main.getPluginPrefix() + "Usage: /spawnboss <boss> [player|x y z]");
            return true;
        }
        if (spawnLocation == null || world == null) {
            sender.sendMessage(this.main.getPluginPrefix() + "Could not determine a valid location.");
            return true;
        }
        boolean success = this.spawnBoss(bossName.toLowerCase(), spawnLocation, world);
        if (success) {
            sender.sendMessage(this.main.getPluginPrefix() + "Spawned " + bossName + " successfully.");
        } else {
            sender.sendMessage(this.main.getPluginPrefix() + "Unknown boss: " + bossName);
        }
        return true;
    }

    private boolean spawnBoss(String name, Location location, World world) {
        switch (name) {
            case "oswaldo": {
                new OswaldoEntity(this.config.getInt("OswaldoHealth"), location, world, this.main);
                break;
            }
            case "bigboy": {
                new BigBoyEntity(this.config.getInt("BigBoyHealth"), location, world, this.main);
                break;
            }
            case "timmothy": {
                new TimmothyEntity(this.config.getInt("TimmothySpawn"), location, world, this.main);
                break;
            }
            case "bartholomew": {
                new BartholomewEntity(this.config.getInt("BartholomewHealth"), location, world, this.main);
                break;
            }
            case "piggy": {
                new PiggyEntity(this.config.getInt("PiggyHealth"), location, world, this.main);
                break;
            }
            case "gort": {
                new GortEntity(this.config.getInt("GortHealth"), location, world, this.main);
                break;
            }
            case "drstrange": {
                new DrStrangeEntity(this.config.getInt("DrStrangeHealth"), location, world, this.main);
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }
}

