/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.gnomed.client.models;

import com.mrbysco.gnomed.client.state.GnomeRenderState;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;

public class GnomeModel
extends EntityModel<GnomeRenderState> {
    private final ModelPart head;
    private final ModelPart torso;
    private final ModelPart left_arm;
    private final ModelPart right_arm;
    private final ModelPart left_leg;
    private final ModelPart right_leg;

    public GnomeModel(ModelPart part) {
        super(part);
        this.head = part.getChild("head");
        this.torso = part.getChild("torso");
        this.left_arm = part.getChild("left_arm");
        this.right_arm = part.getChild("right_arm");
        this.left_leg = part.getChild("left_leg");
        this.right_leg = part.getChild("right_leg");
    }

    public static LayerDefinition createMesh() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        partdefinition.addOrReplaceChild("left_leg", CubeListBuilder.create().texOffs(0, 32).addBox(-1.5f, 0.0f, -1.5f, 3.0f, 4.0f, 3.0f).texOffs(0, 39).addBox("left_foot", -1.5f, 4.0f, -2.5f, 3.0f, 2.0f, 4.0f), PartPose.offset((float)1.5f, (float)18.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("right_leg", CubeListBuilder.create().texOffs(14, 32).addBox(-1.5f, 0.0f, -1.5f, 3.0f, 4.0f, 3.0f).texOffs(14, 39).addBox("right_foot", -1.5f, 4.0f, -2.5f, 3.0f, 2.0f, 4.0f), PartPose.offset((float)-1.5f, (float)18.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("torso", CubeListBuilder.create().texOffs(0, 21).addBox(-3.0f, -3.5f, -2.0f, 6.0f, 7.0f, 4.0f), PartPose.offset((float)0.0f, (float)14.5f, (float)0.0f));
        partdefinition.addOrReplaceChild("left_arm", CubeListBuilder.create().texOffs(28, 32).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 6.0f, 2.0f), PartPose.offset((float)4.0f, (float)11.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("right_arm", CubeListBuilder.create().texOffs(36, 32).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 6.0f, 2.0f), PartPose.offset((float)-4.0f, (float)11.0f, (float)0.0f));
        PartDefinition headDefinition = partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-2.0f, -2.0f, -2.0f, 4.0f, 4.0f, 4.0f).texOffs(0, 8).addBox("beard", -2.5f, 1.0f, -2.5f, 5.0f, 2.0f, 3.0f), PartPose.offset((float)0.0f, (float)9.0f, (float)0.0f));
        headDefinition.addOrReplaceChild("left_ear", CubeListBuilder.create().texOffs(0, 13).addBox("main", 0.2f, -0.6f, -2.0f, 2.0f, 2.0f, 1.0f), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.6517f, (float)-0.2143f));
        headDefinition.addOrReplaceChild("right_ear", CubeListBuilder.create().texOffs(6, 13).addBox("main", -2.2f, -0.6f, -2.0f, 2.0f, 2.0f, 1.0f), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.6517f, (float)0.2143f));
        headDefinition.addOrReplaceChild("nose", CubeListBuilder.create().texOffs(0, 16).addBox("main", -0.5f, 0.0f, -3.3f, 1.0f, 1.0f, 2.0f), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0089f));
        headDefinition.addOrReplaceChild("hat", CubeListBuilder.create().texOffs(16, 0).addBox(-2.5f, -4.2f, -2.5f, 5.0f, 3.0f, 5.0f), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)-0.1607f, (float)0.0f, (float)0.0f));
        headDefinition.addOrReplaceChild("hat_2", CubeListBuilder.create().texOffs(36, 0).addBox("main", -2.0f, -2.6f, -1.8f, 4.0f, 2.0f, 4.0f), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)-0.2588f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void setupAnim(GnomeRenderState state) {
        float limbSwing = state.walkAnimationPos;
        float limbSwingAmount = state.walkAnimationSpeed;
        this.right_leg.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount * 0.5f;
        this.left_leg.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount * 0.5f;
        this.right_leg.yRot = 0.0f;
        this.left_leg.yRot = 0.0f;
    }
}

