/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.gnomed.entity;

import com.mrbysco.gnomed.init.GnomeRegistry;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;

public class Gnome
extends PathfinderMob {
    public Gnome(EntityType<? extends Gnome> entityType, Level level) {
        super(entityType, level);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(4, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false));
        this.goalSelector.addGoal(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.8));
        this.goalSelector.addGoal(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(6, (Goal)new RandomLookAroundGoal((Mob)this));
        this.registerTargetGoals();
    }

    private void registerTargetGoals() {
        this.targetSelector.addGoal(2, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).setAlertOthers(new Class[]{Gnome.class}));
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Gnome.createMobAttributes().add(Attributes.MAX_HEALTH, 10.0).add(Attributes.MOVEMENT_SPEED, (double)0.3f).add(Attributes.KNOCKBACK_RESISTANCE, 0.4).add(Attributes.FOLLOW_RANGE, 30.0);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
    }

    public void tick() {
        if (!this.level().isClientSide) {
            if (this.playerDetection((LevelAccessor)this.level(), 10)) {
                if (this.hasEffect(MobEffects.INVISIBILITY)) {
                    this.removeEffect(MobEffects.INVISIBILITY);
                }
            } else if (!this.hasEffect(MobEffects.INVISIBILITY)) {
                this.addEffect(new MobEffectInstance(MobEffects.INVISIBILITY, 9600, 0));
            }
        }
        super.tick();
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor levelAccessor, DifficultyInstance difficultyInstance, EntitySpawnReason spawnType, @Nullable SpawnGroupData groupData) {
        if (!levelAccessor.isClientSide() && this.playerDetection((LevelAccessor)levelAccessor, 5)) {
            this.playSound((SoundEvent)GnomeRegistry.GNOME_SPAWN.get(), 1.0f, 1.0f);
        }
        return super.finalizeSpawn(levelAccessor, difficultyInstance, spawnType, groupData);
    }

    private boolean playerDetection(LevelAccessor levelAccessor, int range) {
        AABB aabb = new AABB(this.getX() - 0.5, this.getY() - 0.5, this.getZ() - 0.5, this.getX() + 0.5, this.getY() + 0.5, this.getZ() + 0.5).inflate((double)range);
        return !levelAccessor.getEntitiesOfClass(Player.class, aabb).isEmpty();
    }

    @Nullable
    protected SoundEvent getAmbientSound() {
        return (SoundEvent)GnomeRegistry.GNOME_PASSIVE.get();
    }

    protected SoundEvent getHurtSound(DamageSource damageSourceIn) {
        return (SoundEvent)GnomeRegistry.GNOME_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)GnomeRegistry.GNOME_DEATH.get();
    }

    protected float getSoundVolume() {
        return 0.4f;
    }
}

