/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.unbreakables;

import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.WeakHashMap;
import java.util.function.Consumer;
import net.blay09.mods.unbreakables.BreakContextImpl;
import net.blay09.mods.unbreakables.api.BreakContext;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class BreakTracker {
    private static final Map<Player, BreakContext> contexts = Collections.synchronizedMap(new WeakHashMap());

    public static void startBreak(Player player) {
        contexts.remove(player);
    }

    public static void stopBreak(Player player) {
        contexts.remove(player);
    }

    public static BreakContext getOrCreateContext(BlockGetter blockGetter, BlockPos pos, BlockState state, Player player, Consumer<BreakContext> initializer) {
        return contexts.computeIfAbsent(player, key -> {
            BreakContextImpl breakContext = new BreakContextImpl(blockGetter, pos, state, player);
            initializer.accept(breakContext);
            return breakContext;
        });
    }

    public static Optional<BreakContext> getContext(Player player) {
        return BreakTracker.getContext(player, null);
    }

    public static Optional<BreakContext> getContext(Player player, @Nullable BlockPos pos) {
        BreakContext breakContext = contexts.get(player);
        if (breakContext != null && (pos == null || breakContext.getPos().equals((Object)pos))) {
            return Optional.of(breakContext);
        }
        contexts.remove(player);
        return Optional.empty();
    }
}

