/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.unbreakables;

import net.blay09.mods.balm.api.Balm;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;

public class CooldownTracker {
    private static final String COOLDOWNS = "Cooldowns";

    public static CompoundTag getUnbreakablesData(Player player) {
        CompoundTag playerData = Balm.getHooks().getPersistentData(player);
        CompoundTag unbreakablesData = playerData.m_128469_("unbreakables");
        playerData.m_128365_("unbreakables", (Tag)unbreakablesData);
        return unbreakablesData;
    }

    public static long getCooldownUntil(Player player, ResourceLocation id) {
        CompoundTag data = CooldownTracker.getUnbreakablesData(player);
        CompoundTag cooldowns = data.m_128469_(COOLDOWNS);
        return cooldowns.m_128454_(id.toString());
    }

    public static long getCooldownMillisLeft(Player player, ResourceLocation id) {
        long cooldownUntil = CooldownTracker.getCooldownUntil(player, id);
        return Math.max(0L, cooldownUntil - System.currentTimeMillis());
    }

    public static void setCooldownUntil(Player player, ResourceLocation id, long timestamp) {
        CompoundTag data = CooldownTracker.getUnbreakablesData(player);
        CompoundTag cooldowns = data.m_128469_(COOLDOWNS);
        cooldowns.m_128356_(id.toString(), timestamp);
        data.m_128365_(COOLDOWNS, (Tag)cooldowns);
    }
}

