/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.unbreakables.rules;

import java.util.Optional;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.unbreakables.api.BreakContext;
import net.blay09.mods.unbreakables.api.parameter.FloatParameter;
import net.blay09.mods.unbreakables.api.parameter.IdParameter;
import net.blay09.mods.unbreakables.api.parameter.PositionParameter;
import net.blay09.mods.unbreakables.api.parameter.TaggableIdParameter;
import net.blay09.mods.unbreakables.rules.RuleRegistry;
import net.blay09.mods.unbreakables.rules.parameters.BiFloatParameter;
import net.blay09.mods.unbreakables.rules.parameters.BoundsParameter;
import net.blay09.mods.unbreakables.rules.parameters.EntityNearbyParameter;
import net.blay09.mods.unbreakables.rules.parameters.FloatCountedIdParameter;
import net.blay09.mods.unbreakables.rules.parameters.IsNearParameter;
import net.blay09.mods.unbreakables.rules.parameters.IsNearPoiParameter;
import net.blay09.mods.unbreakables.rules.parameters.PropertyParameter;
import net.minecraft.advancements.Advancement;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class InbuiltConditions {
    public static void register() {
        RuleRegistry.registerConditionResolver("is_block", TaggableIdParameter.class, (context, parameters) -> parameters.isTag() ? context.getState().m_204336_(TagKey.m_203882_((ResourceKey)Registries.f_256747_, (ResourceLocation)parameters.value())) : BuiltInRegistries.f_256975_.m_7981_((Object)context.getState().m_60734_()).equals((Object)parameters.value()));
        RuleRegistry.registerConditionResolver("is_tag", IdParameter.class, (context, parameters) -> context.getState().m_204336_(TagKey.m_203882_((ResourceKey)Registries.f_256747_, (ResourceLocation)parameters.value())));
        RuleRegistry.registerConditionResolver("is_state", PropertyParameter.class, (context, parameters) -> {
            for (Property property : context.getState().m_61147_()) {
                String stringValue;
                String string;
                if (!property.m_61708_().equals(parameters.property().value())) continue;
                Comparable value = context.getState().m_61143_(property);
                if (value instanceof StringRepresentable) {
                    StringRepresentable rep = (StringRepresentable)value;
                    string = rep.m_7912_();
                } else {
                    string = value.toString();
                }
                if (!(stringValue = string).equals(parameters.value().value())) continue;
                return true;
            }
            return false;
        });
        RuleRegistry.registerConditionResolver("is_in_dimension", IdParameter.class, (context, parameters) -> InbuiltConditions.pickLevel(context).map(it -> it.m_46472_().m_135782_().equals((Object)parameters.value())).orElse(false));
        RuleRegistry.registerConditionResolver("is_in_biome", TaggableIdParameter.class, (context, parameters) -> InbuiltConditions.pickLevelAccessor(context).map(it -> parameters.isTag() ? it.m_204166_(context.getPos()).m_203656_(TagKey.m_203882_((ResourceKey)Registries.f_256952_, (ResourceLocation)parameters.value())) : it.m_204166_(context.getPos()).m_203373_(parameters.value())).orElse(false));
        RuleRegistry.registerConditionResolver("has_effect", FloatCountedIdParameter.class, (context, parameters) -> {
            Player player = context.getPlayer();
            MobEffect effect = (MobEffect)BuiltInRegistries.f_256974_.m_7745_(parameters.id().value());
            if (effect != null && player != null) {
                MobEffectInstance effectInstance = player.m_21124_(effect);
                if (effectInstance != null) {
                    int amplifier = effectInstance.m_19564_();
                    return (float)amplifier >= parameters.count().value() - 1.0f;
                }
                return false;
            }
            return false;
        });
        RuleRegistry.registerConditionResolver("is_tool", TaggableIdParameter.class, (context, parameters) -> {
            Player player = context.getPlayer();
            if (player == null) {
                return false;
            }
            return parameters.isTag() ? player.m_21205_().m_204117_(TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)parameters.value())) : player.m_21205_().m_150930_((Item)BuiltInRegistries.f_257033_.m_7745_(parameters.value()));
        });
        RuleRegistry.registerConditionResolver("is_enchanted", FloatCountedIdParameter.class, (context, parameters) -> {
            Player player = context.getPlayer();
            if (player == null) {
                return false;
            }
            ItemStack item = context.getPlayer().m_21205_();
            Enchantment enchantment = (Enchantment)BuiltInRegistries.f_256876_.m_7745_(parameters.id().value());
            if (enchantment != null) {
                int level = EnchantmentHelper.m_44843_((Enchantment)enchantment, (ItemStack)item);
                return (float)level >= parameters.count().value();
            }
            return false;
        });
        RuleRegistry.registerConditionResolver("players_nearby", BiFloatParameter.class, (context, parameters) -> InbuiltConditions.pickLevel(context).map(level -> (float)level.m_6249_((Entity)context.getPlayer(), AABB.m_165882_((Vec3)context.getPos().m_252807_(), (double)parameters.first().value(), (double)parameters.first().value(), (double)parameters.first().value()), EntitySelector.f_20408_).size() >= parameters.second().value()).orElse(false));
        RuleRegistry.registerConditionResolver("mobs_nearby", BiFloatParameter.class, (context, parameters) -> InbuiltConditions.pickLevel(context).map(level -> (float)level.m_6249_((Entity)context.getPlayer(), AABB.m_165882_((Vec3)context.getPos().m_252807_(), (double)parameters.first().value(), (double)parameters.first().value(), (double)parameters.first().value()), it -> it instanceof Mob).size() >= parameters.second().value()).orElse(false));
        RuleRegistry.registerConditionResolver("animals_nearby", BiFloatParameter.class, (context, parameters) -> InbuiltConditions.pickLevel(context).map(level -> (float)level.m_6249_((Entity)context.getPlayer(), AABB.m_165882_((Vec3)context.getPos().m_252807_(), (double)parameters.first().value(), (double)parameters.first().value(), (double)parameters.first().value()), it -> it instanceof Animal).size() >= parameters.second().value()).orElse(false));
        RuleRegistry.registerConditionResolver("entity_nearby", EntityNearbyParameter.class, (context, parameters) -> InbuiltConditions.pickLevel(context).map(level -> (float)level.m_6249_((Entity)context.getPlayer(), AABB.m_165882_((Vec3)context.getPos().m_252807_(), (double)parameters.distance().value(), (double)parameters.distance().value(), (double)parameters.distance().value()), it -> parameters.entity().isTag() ? it.m_6095_().m_204039_(TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)parameters.entity().value())) : BuiltInRegistries.f_256780_.m_7981_((Object)it.m_6095_()).equals((Object)parameters.entity().value())).size() >= parameters.minimum().value()).orElse(false));
        RuleRegistry.registerConditionResolver("is_above_y", FloatParameter.class, (context, parameters) -> {
            BlockPos pos = context.getPos();
            return (float)pos.m_123342_() > parameters.value();
        });
        RuleRegistry.registerConditionResolver("is_below_y", FloatParameter.class, (context, parameters) -> {
            BlockPos pos = context.getPos();
            return (float)pos.m_123342_() < parameters.value();
        });
        RuleRegistry.registerConditionResolver("is_within", BoundsParameter.class, (context, parameters) -> {
            BlockPos pos = context.getPos();
            return pos.m_123341_() >= parameters.minX().value() && pos.m_123341_() <= parameters.maxX().value() && pos.m_123342_() >= parameters.minY().value() && pos.m_123342_() <= parameters.maxY().value() && pos.m_123343_() >= parameters.minZ().value() && pos.m_123343_() <= parameters.maxZ().value();
        });
        RuleRegistry.registerConditionResolver("is_at", PositionParameter.class, (context, parameters) -> {
            BlockPos pos = context.getPos();
            return pos.m_123341_() == parameters.x().value() && pos.m_123342_() == parameters.y().value() && pos.m_123343_() == parameters.z().value();
        });
        RuleRegistry.registerConditionResolver("is_near", IsNearParameter.class, (context, parameters) -> {
            BlockPos pos = context.getPos();
            BlockPos rulePos = new BlockPos(parameters.x().value(), parameters.y().value(), parameters.z().value());
            float maxDist = parameters.distance().value();
            double dist = pos.m_123331_((Vec3i)rulePos);
            return dist <= (double)(maxDist * maxDist);
        });
        RuleRegistry.registerConditionResolver("is_near_poi", IsNearPoiParameter.class, (context, parameters) -> context.viaServer(serverLevel -> {
            Optional poi = serverLevel.m_8904_().m_218002_(it -> false, context.getPos(), (int)parameters.distance().value(), PoiManager.Occupancy.ANY);
            return poi.isPresent();
        }));
        RuleRegistry.registerConditionResolver("is_player", IsNearParameter.class, (context, parameters) -> {
            Player player = context.getPlayer();
            return player != null && !Balm.getHooks().isFakePlayer(player);
        });
        RuleRegistry.registerConditionResolver("has_advancement", IdParameter.class, (context, parameters) -> context.viaServer(serverLevel -> {
            ServerPlayer serverPlayer;
            Advancement advancement;
            Player patt10756$temp = context.getPlayer();
            if (patt10756$temp instanceof ServerPlayer && (advancement = (serverPlayer = (ServerPlayer)patt10756$temp).m_9236_().m_7654_().m_129889_().m_136041_(parameters.value())) != null) {
                return serverPlayer.m_8960_().m_135996_(advancement).m_8193_();
            }
            return false;
        }));
    }

    private static Optional<LevelAccessor> pickLevelAccessor(BreakContext context) {
        BlockGetter blockGetter = context.getBlockGetter();
        if (blockGetter instanceof LevelAccessor) {
            LevelAccessor level = (LevelAccessor)blockGetter;
            return Optional.of(level);
        }
        return Optional.ofNullable(context.getPlayer()).map(Entity::m_9236_);
    }

    private static Optional<Level> pickLevel(BreakContext context) {
        BlockGetter blockGetter = context.getBlockGetter();
        if (blockGetter instanceof Level) {
            Level level = (Level)blockGetter;
            return Optional.of(level);
        }
        return Optional.ofNullable(context.getPlayer()).map(Entity::m_9236_);
    }
}

