/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.unbreakables;

import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import net.blay09.mods.balm.Balm;
import net.blay09.mods.unbreakables.api.BreakContext;
import net.blay09.mods.unbreakables.api.BreakRequirement;
import net.blay09.mods.unbreakables.api.ConfiguredCondition;
import net.blay09.mods.unbreakables.api.RequirementFunction;
import net.blay09.mods.unbreakables.api.VariableResolver;
import net.blay09.mods.unbreakables.network.ClientboundUnbreakableStatusPacket;
import net.blay09.mods.unbreakables.rules.ConfiguredRule;
import net.blay09.mods.unbreakables.rules.RuleRegistry;
import net.blay09.mods.unbreakables.rules.hint.NoHint;
import net.blay09.mods.unbreakables.rules.requirements.ClientsideAssumedRequirement;
import net.blay09.mods.unbreakables.rules.requirements.CombinedRequirement;
import net.blay09.mods.unbreakables.rules.requirements.ConfiguredRequirement;
import net.blay09.mods.unbreakables.rules.requirements.NoRequirement;
import net.minecraft.class_1657;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_8710;

public class BreakContextImpl
implements BreakContext {
    private final Map<class_2960, BreakRequirement> requirements = new HashMap<class_2960, BreakRequirement>();
    private final class_1922 blockGetter;
    private final class_2338 pos;
    private final class_2680 state;
    private final WeakReference<class_1657> player;
    private boolean hasServersideConditions;
    private BreakRequirement resolvedRequirement;

    public BreakContextImpl(class_1922 blockGetter, class_2338 pos, class_2680 state, class_1657 player) {
        this.blockGetter = blockGetter;
        this.pos = pos;
        this.state = state;
        this.player = new WeakReference<class_1657>(player);
    }

    public <T extends BreakRequirement, P> void apply(ConfiguredRule<T, P> configuredModifier) {
        for (ConfiguredCondition<?> condition : configuredModifier.conditions()) {
            if (this.matchesCondition(condition)) continue;
            return;
        }
        ConfiguredRequirement<T, P> requirement = configuredModifier.requirement();
        RequirementFunction<T, P> modifier = requirement.modifier();
        P parameters = requirement.parameters();
        BreakRequirement existing = this.requirements.get(modifier.getRequirementType());
        if (existing == null) {
            existing = RuleRegistry.getRequirementType(modifier.getRequirementType()).createInstance();
        }
        this.requirements.put(modifier.getRequirementType(), modifier.apply(existing, this, parameters));
    }

    @Override
    public float getContextValue(class_2960 id) {
        VariableResolver resolver = RuleRegistry.getVariableResolver(id);
        if (resolver != null) {
            return resolver.resolve(this);
        }
        return 0.0f;
    }

    @Override
    public <P> boolean matchesCondition(ConfiguredCondition<P> configuredCondition) {
        return configuredCondition.resolver().matches(this, configuredCondition.parameters());
    }

    @Override
    public BreakRequirement resolve() {
        if (this.resolvedRequirement != null) {
            return this.resolvedRequirement;
        }
        BreakRequirement result = this.requirements.isEmpty() ? NoRequirement.INSTANCE : (this.requirements.size() == 1 ? this.requirements.values().iterator().next() : new CombinedRequirement(this.requirements.values()));
        this.resolvedRequirement = result;
        class_1657 player = (class_1657)this.player.get();
        if (player != null) {
            boolean breakable = this.resolvedRequirement.canAfford(this, player);
            if (this.hasServersideConditions && player instanceof class_3222) {
                Balm.networking().sendTo(player, (class_8710)new ClientboundUnbreakableStatusPacket(this.pos, result.hint(this, player).orElse(NoHint.INSTANCE), breakable));
            }
        }
        return result;
    }

    public void resolve(BreakRequirement resolvedRequirement) {
        this.resolvedRequirement = resolvedRequirement;
    }

    @Override
    public class_1922 getBlockGetter() {
        return this.blockGetter;
    }

    @Override
    public class_2338 getPos() {
        return this.pos;
    }

    @Override
    public class_2680 getState() {
        return this.state;
    }

    @Override
    public boolean viaServer(Function<class_3218, Boolean> runner) {
        this.hasServersideConditions = true;
        class_1922 class_19222 = this.blockGetter;
        if (class_19222 instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19222;
            return runner.apply(serverLevel);
        }
        this.resolvedRequirement = ClientsideAssumedRequirement.INSTANCE;
        return false;
    }

    @Override
    public class_1657 getPlayer() {
        return (class_1657)this.player.get();
    }
}

