/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.unbreakables;

import net.blay09.mods.balm.Balm;
import net.blay09.mods.balm.core.BalmRegistrars;
import net.blay09.mods.balm.platform.event.EventPhases;
import net.blay09.mods.balm.platform.event.callback.BlockCallback;
import net.blay09.mods.balm.platform.event.callback.ServerPlayerCallback;
import net.blay09.mods.unbreakables.BreakContextImpl;
import net.blay09.mods.unbreakables.BreakTracker;
import net.blay09.mods.unbreakables.UnbreakablesConfig;
import net.blay09.mods.unbreakables.api.BreakContext;
import net.blay09.mods.unbreakables.api.BreakRequirement;
import net.blay09.mods.unbreakables.api.UnbreakablesAPI;
import net.blay09.mods.unbreakables.network.ModNetworking;
import net.blay09.mods.unbreakables.network.UnbreakableRulesMessage;
import net.blay09.mods.unbreakables.rules.InbuiltConditions;
import net.blay09.mods.unbreakables.rules.InbuiltParameters;
import net.blay09.mods.unbreakables.rules.InbuiltRequirements;
import net.blay09.mods.unbreakables.rules.hint.CombinedHint;
import net.blay09.mods.unbreakables.rules.hint.CooldownHint;
import net.blay09.mods.unbreakables.rules.hint.ExperienceLevelHint;
import net.blay09.mods.unbreakables.rules.hint.ExperiencePointsHint;
import net.blay09.mods.unbreakables.rules.hint.ItemHint;
import net.blay09.mods.unbreakables.rules.hint.MessageHint;
import net.blay09.mods.unbreakables.rules.hint.NoHint;
import net.blay09.mods.unbreakables.rulesets.RulesetLoader;
import net.minecraft.class_1657;
import net.minecraft.class_1922;
import net.minecraft.class_3302;
import net.minecraft.class_8710;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Unbreakables {
    public static final Logger logger = LoggerFactory.getLogger(Unbreakables.class);
    public static final String MOD_ID = "unbreakables";

    public static void initialize(BalmRegistrars registrars) {
        InbuiltParameters.register();
        InbuiltConditions.register();
        InbuiltRequirements.register();
        UnbreakablesAPI.registerHintSerializer(CombinedHint.ID, CombinedHint.CombinedBreakHintSerializer.INSTANCE);
        UnbreakablesAPI.registerHintSerializer(NoHint.ID, NoHint.NoHintSerializer.INSTANCE);
        UnbreakablesAPI.registerHintSerializer(MessageHint.ID, MessageHint.MessageHintSerializer.INSTANCE);
        UnbreakablesAPI.registerHintSerializer(CooldownHint.ID, CooldownHint.CooldownHintSerializer.INSTANCE);
        UnbreakablesAPI.registerHintSerializer(ExperienceLevelHint.ID, ExperienceLevelHint.ExperienceLevelHintSerializer.INSTANCE);
        UnbreakablesAPI.registerHintSerializer(ExperiencePointsHint.ID, ExperiencePointsHint.ExperiencePointsHintSerializer.INSTANCE);
        UnbreakablesAPI.registerHintSerializer(ItemHint.ID, ItemHint.ItemHintSerializer.INSTANCE);
        UnbreakablesConfig.initialize();
        ModNetworking.initialize(Balm.networking());
        registrars.resourceReloadListeners(registrar -> registrar.register("json_rulesets", (class_3302)new RulesetLoader()));
        ServerPlayerCallback.Join.EVENT.register(player -> Balm.networking().sendTo((class_1657)player, (class_8710)new UnbreakableRulesMessage(RulesetLoader.getRules())));
        BlockCallback.DigSpeed.EVENT.register((blockGetter, pos, state, player, speed) -> {
            BreakContext breakContext = BreakTracker.getOrCreateContext(blockGetter, pos, state, player, context -> RulesetLoader.getLoadedRules().forEach(it -> ((BreakContextImpl)context).apply(it)));
            BreakRequirement requirement = breakContext.resolve();
            return !requirement.canAfford(breakContext, player) ? 0.0f : speed;
        });
        BlockCallback.Break.Before.EVENT.register(EventPhases.HIGHEST, (level, pos, state, blockEntity, player) -> {
            if (player.method_31549().field_7477) {
                return true;
            }
            BreakContextImpl breakContext = new BreakContextImpl((class_1922)level, pos, state, player);
            RulesetLoader.getLoadedRules().forEach(breakContext::apply);
            BreakRequirement requirement = breakContext.resolve();
            return requirement.canAfford(breakContext, player);
        });
        BlockCallback.Break.Before.EVENT.register(EventPhases.LOWEST, (level, pos, state, blockEntity, player) -> {
            if (player.method_31549().field_7477) {
                return true;
            }
            BreakContextImpl breakContext = new BreakContextImpl((class_1922)level, pos, state, player);
            RulesetLoader.getLoadedRules().forEach(breakContext::apply);
            BreakRequirement requirement = breakContext.resolve();
            if (!requirement.canAfford(breakContext, player)) {
                return false;
            }
            requirement.consume(player);
            return true;
        });
    }
}

