/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.unbreakables;

import net.blay09.mods.balm.Balm;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.Identifier;
import net.minecraft.world.entity.player.Player;

public class CooldownTracker {
    private static final String COOLDOWNS = "Cooldowns";

    public static CompoundTag getUnbreakablesData(Player player) {
        CompoundTag playerData = Balm.hooks().getPersistentData(player);
        CompoundTag unbreakablesData = playerData.getCompoundOrEmpty("unbreakables");
        playerData.put("unbreakables", (Tag)unbreakablesData);
        return unbreakablesData;
    }

    public static long getCooldownUntil(Player player, Identifier id) {
        CompoundTag data = CooldownTracker.getUnbreakablesData(player);
        return data.getCompound(COOLDOWNS).flatMap(it -> it.getLong(id.toString())).orElse(0L);
    }

    public static long getCooldownMillisLeft(Player player, Identifier id) {
        long cooldownUntil = CooldownTracker.getCooldownUntil(player, id);
        return Math.max(0L, cooldownUntil - System.currentTimeMillis());
    }

    public static void setCooldownUntil(Player player, Identifier id, long timestamp) {
        CompoundTag data = CooldownTracker.getUnbreakablesData(player);
        CompoundTag cooldowns = data.getCompoundOrEmpty(COOLDOWNS);
        cooldowns.putLong(id.toString(), timestamp);
        data.put(COOLDOWNS, (Tag)cooldowns);
    }
}

