/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.unbreakables.client;

import net.blay09.mods.balm.client.BalmClientRegistrars;
import net.blay09.mods.balm.client.platform.event.callback.RenderCallback;
import net.blay09.mods.unbreakables.BreakTracker;
import net.blay09.mods.unbreakables.api.BreakContext;
import net.blay09.mods.unbreakables.api.BreakRequirement;
import net.blay09.mods.unbreakables.api.client.BreakHintRenderer;
import net.blay09.mods.unbreakables.api.client.UnbreakablesClientAPI;
import net.blay09.mods.unbreakables.client.hint.BreakHintClientRegistry;
import net.blay09.mods.unbreakables.client.hint.CombinedHintRenderer;
import net.blay09.mods.unbreakables.client.hint.CooldownHintRenderer;
import net.blay09.mods.unbreakables.client.hint.ExperienceLevelHintRenderer;
import net.blay09.mods.unbreakables.client.hint.ExperiencePointsHintRenderer;
import net.blay09.mods.unbreakables.client.hint.ItemHintRenderer;
import net.blay09.mods.unbreakables.client.hint.MessageHintRenderer;
import net.blay09.mods.unbreakables.mixin.MultiPlayerGameModeAccessor;
import net.blay09.mods.unbreakables.rules.hint.CombinedHint;
import net.blay09.mods.unbreakables.rules.hint.CooldownHint;
import net.blay09.mods.unbreakables.rules.hint.ExperienceLevelHint;
import net.blay09.mods.unbreakables.rules.hint.ExperiencePointsHint;
import net.blay09.mods.unbreakables.rules.hint.ItemHint;
import net.blay09.mods.unbreakables.rules.hint.MessageHint;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.MultiPlayerGameMode;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.player.Player;

public class UnbreakablesClient {
    public static void initialize(BalmClientRegistrars registrars) {
        UnbreakablesClientAPI.registerHintRenderer(MessageHint.ID, new MessageHintRenderer());
        UnbreakablesClientAPI.registerHintRenderer(CooldownHint.ID, new CooldownHintRenderer());
        UnbreakablesClientAPI.registerHintRenderer(ExperiencePointsHint.ID, new ExperiencePointsHintRenderer());
        UnbreakablesClientAPI.registerHintRenderer(ExperienceLevelHint.ID, new ExperienceLevelHintRenderer());
        UnbreakablesClientAPI.registerHintRenderer(CombinedHint.ID, new CombinedHintRenderer());
        UnbreakablesClientAPI.registerHintRenderer(ItemHint.ID, new ItemHintRenderer());
        RenderCallback.Gui.AFTER.register((guiGraphics, window) -> {
            LocalPlayer player = Minecraft.getInstance().player;
            if (player == null) {
                return;
            }
            MultiPlayerGameMode gameMode = Minecraft.getInstance().gameMode;
            if (gameMode == null || !gameMode.isDestroying()) {
                return;
            }
            BreakTracker.getContext((Player)player, ((MultiPlayerGameModeAccessor)gameMode).getDestroyBlockPos()).ifPresent(context -> {
                BreakRequirement requirement = context.resolve();
                requirement.hint((BreakContext)context, (Player)player).ifPresent(hint -> {
                    BreakHintRenderer<?> renderer = BreakHintClientRegistry.getRenderer(hint.id());
                    if (renderer != null) {
                        float partialTicks = Minecraft.getInstance().getDeltaTracker().getRealtimeDeltaTicks();
                        renderer.render(window, guiGraphics, partialTicks, hint);
                    }
                });
            });
        });
    }
}

