/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.unbreakables.rules;

import net.blay09.mods.unbreakables.api.parameter.ComponentParameter;
import net.blay09.mods.unbreakables.api.parameter.FloatParameter;
import net.blay09.mods.unbreakables.api.parameter.IntParameter;
import net.blay09.mods.unbreakables.rules.RuleRegistry;
import net.blay09.mods.unbreakables.rules.parameters.CooldownParameter;
import net.blay09.mods.unbreakables.rules.parameters.FloatCountedIdParameter;
import net.blay09.mods.unbreakables.rules.parameters.VariableScaledCooldownParameter;
import net.blay09.mods.unbreakables.rules.parameters.VariableScaledFloatCountedIdParameter;
import net.blay09.mods.unbreakables.rules.parameters.VariableScaledParameter;
import net.blay09.mods.unbreakables.rules.requirements.CooldownRequirementType;
import net.blay09.mods.unbreakables.rules.requirements.ExperienceLevelRequirementType;
import net.blay09.mods.unbreakables.rules.requirements.ExperiencePointsRequirementType;
import net.blay09.mods.unbreakables.rules.requirements.ItemRequirementType;
import net.blay09.mods.unbreakables.rules.requirements.RefuseRequirement;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class InbuiltRequirements {
    public static void register() {
        ExperiencePointsRequirementType experiencePointRequirements = new ExperiencePointsRequirementType();
        ExperienceLevelRequirementType experienceLevelRequirements = new ExperienceLevelRequirementType();
        CooldownRequirementType cooldownRequirements = new CooldownRequirementType();
        ItemRequirementType itemRequirements = new ItemRequirementType();
        RuleRegistry.register(experiencePointRequirements);
        RuleRegistry.register(experienceLevelRequirements);
        RuleRegistry.register(cooldownRequirements);
        RuleRegistry.register(itemRequirements);
        RuleRegistry.registerModifier("add_level_cost", experienceLevelRequirements, FloatParameter.class, (cost, context, parameters) -> {
            cost.setLevels((int)((float)cost.getLevels() + parameters.value()));
            return cost;
        }, () -> true);
        RuleRegistry.registerModifier("multiply_level_cost", experienceLevelRequirements, FloatParameter.class, (cost, context, parameters) -> {
            cost.setLevels((int)((float)cost.getLevels() * parameters.value()));
            return cost;
        }, () -> true);
        RuleRegistry.registerModifier("scaled_add_level_cost", experienceLevelRequirements, VariableScaledParameter.class, (cost, context, parameters) -> {
            float sourceValue = context.getContextValue(parameters.id().value());
            cost.setLevels((int)((float)cost.getLevels() + sourceValue * parameters.scale().value()));
            return cost;
        }, () -> true);
        RuleRegistry.registerModifier("scaled_multiply_level_cost", experienceLevelRequirements, VariableScaledParameter.class, (cost, context, parameters) -> {
            float sourceValue = context.getContextValue(parameters.id().value());
            cost.setLevels((int)((float)cost.getLevels() * sourceValue * parameters.scale().value()));
            return cost;
        }, () -> true);
        RuleRegistry.registerModifier("min_level_cost", experienceLevelRequirements, IntParameter.class, (cost, context, parameters) -> {
            cost.setLevels(Math.max(cost.getLevels(), parameters.value()));
            return cost;
        }, () -> true);
        RuleRegistry.registerModifier("max_level_cost", experienceLevelRequirements, IntParameter.class, (cost, context, parameters) -> {
            cost.setLevels(Math.min(cost.getLevels(), parameters.value()));
            return cost;
        }, () -> true);
        RuleRegistry.registerModifier("add_xp_cost", experiencePointRequirements, IntParameter.class, (cost, context, parameters) -> {
            cost.setPoints(cost.getPoints() + parameters.value());
            return cost;
        }, () -> true);
        RuleRegistry.registerModifier("multiply_xp_cost", experiencePointRequirements, FloatParameter.class, (cost, context, parameters) -> {
            cost.setPoints((int)((float)cost.getPoints() * parameters.value()));
            return cost;
        }, () -> true);
        RuleRegistry.registerModifier("scaled_add_xp_cost", experiencePointRequirements, VariableScaledParameter.class, (cost, context, parameters) -> {
            float sourceValue = context.getContextValue(parameters.id().value());
            cost.setPoints((int)((float)cost.getPoints() + sourceValue * parameters.scale().value()));
            return cost;
        }, () -> true);
        RuleRegistry.registerModifier("scaled_multiply_level_cost", experiencePointRequirements, VariableScaledParameter.class, (cost, context, parameters) -> {
            float sourceValue = context.getContextValue(parameters.id().value());
            cost.setPoints((int)((float)cost.getPoints() * sourceValue * parameters.scale().value()));
            return cost;
        }, () -> true);
        RuleRegistry.registerModifier("min_xp_cost", experiencePointRequirements, IntParameter.class, (cost, context, parameters) -> {
            cost.setPoints(Math.max(cost.getPoints(), parameters.value()));
            return cost;
        }, () -> true);
        RuleRegistry.registerModifier("max_xp_cost", experiencePointRequirements, IntParameter.class, (cost, context, parameters) -> {
            cost.setPoints(Math.min(cost.getPoints(), parameters.value()));
            return cost;
        }, () -> true);
        RuleRegistry.registerModifier("add_cooldown", cooldownRequirements, CooldownParameter.class, (cost, context, parameters) -> {
            cost.setCooldown(parameters.id().value(), (int)((float)cost.getCooldownSeconds() + parameters.seconds().value()));
            return cost;
        }, () -> true);
        RuleRegistry.registerModifier("multiply_cooldown", cooldownRequirements, CooldownParameter.class, (cost, context, parameters) -> {
            cost.setCooldown(parameters.id().value(), (int)((float)cost.getCooldownSeconds() * parameters.seconds().value()));
            return cost;
        }, () -> true);
        RuleRegistry.registerModifier("scaled_add_cooldown", cooldownRequirements, VariableScaledCooldownParameter.class, (cost, context, parameters) -> {
            float sourceValue = context.getContextValue(parameters.variable().value());
            cost.setCooldown(parameters.cooldown().value(), (int)((float)cost.getCooldownSeconds() + sourceValue * parameters.seconds().value()));
            return cost;
        }, () -> true);
        RuleRegistry.registerModifier("scaled_multiply_cooldown", cooldownRequirements, VariableScaledCooldownParameter.class, (cost, context, parameters) -> {
            float sourceValue = context.getContextValue(parameters.variable().value());
            cost.setCooldown(parameters.cooldown().value(), (int)((float)cost.getCooldownSeconds() * sourceValue * parameters.seconds().value()));
            return cost;
        }, () -> true);
        RuleRegistry.registerModifier("min_cooldown", cooldownRequirements, CooldownParameter.class, (cost, context, parameters) -> {
            cost.setCooldown(parameters.id().value(), (int)Math.max((float)cost.getCooldownSeconds(), parameters.seconds().value()));
            return cost;
        }, () -> true);
        RuleRegistry.registerModifier("max_cooldown", cooldownRequirements, CooldownParameter.class, (cost, context, parameters) -> {
            cost.setCooldown(parameters.id().value(), (int)Math.min((float)cost.getCooldownSeconds(), parameters.seconds().value()));
            return cost;
        }, () -> true);
        RuleRegistry.registerModifier("add_item_cost", itemRequirements, FloatCountedIdParameter.class, (cost, context, parameters) -> {
            Item item = (Item)BuiltInRegistries.ITEM.getValue(parameters.id().value());
            if (cost.getItemStack().getItem() != item) {
                cost.setItemStack(new ItemStack((ItemLike)item));
                cost.setCount((int)parameters.count().value());
            } else {
                cost.setCount((int)((float)cost.getCount() + parameters.count().value()));
            }
            return cost;
        }, () -> true);
        RuleRegistry.registerModifier("multiply_item_cost", itemRequirements, FloatCountedIdParameter.class, (cost, context, parameters) -> {
            Item item = (Item)BuiltInRegistries.ITEM.getValue(parameters.id().value());
            if (cost.getItemStack().getItem() != item) {
                cost.setItemStack(new ItemStack((ItemLike)item));
                cost.setCount((int)parameters.count().value());
            } else {
                cost.setCount((int)((float)cost.getCount() * parameters.count().value()));
            }
            return cost;
        }, () -> true);
        RuleRegistry.registerModifier("scaled_add_item_cost", itemRequirements, VariableScaledFloatCountedIdParameter.class, (cost, context, parameters) -> {
            Item item = (Item)BuiltInRegistries.ITEM.getValue(parameters.item().value());
            if (cost.getItemStack().getItem() != item) {
                cost.setItemStack(new ItemStack((ItemLike)item));
                cost.setCount((int)(context.getContextValue(parameters.variable().value()) * parameters.count().value()));
            } else {
                cost.setCount((int)((float)cost.getCount() + context.getContextValue(parameters.variable().value()) * parameters.count().value()));
            }
            return cost;
        }, () -> true);
        RuleRegistry.registerModifier("scaled_multiply_item_cost", itemRequirements, VariableScaledFloatCountedIdParameter.class, (cost, context, parameters) -> {
            Item item = (Item)BuiltInRegistries.ITEM.getValue(parameters.item().value());
            if (cost.getItemStack().getItem() != item) {
                cost.setItemStack(new ItemStack((ItemLike)item));
                cost.setCount((int)(context.getContextValue(parameters.variable().value()) * parameters.count().value()));
            } else {
                cost.setCount((int)((float)cost.getCount() * context.getContextValue(parameters.variable().value()) * parameters.count().value()));
            }
            return cost;
        }, () -> true);
        RuleRegistry.registerModifier("min_item_cost", itemRequirements, FloatCountedIdParameter.class, (cost, context, parameters) -> {
            Item item = (Item)BuiltInRegistries.ITEM.getValue(parameters.id().value());
            if (cost.getItemStack().getItem() != item) {
                cost.setItemStack(new ItemStack((ItemLike)item));
                cost.setCount((int)parameters.count().value());
            } else {
                cost.setCount(Math.max(cost.getCount(), (int)parameters.count().value()));
            }
            return cost;
        }, () -> true);
        RuleRegistry.registerModifier("max_item_cost", itemRequirements, FloatCountedIdParameter.class, (cost, context, parameters) -> {
            Item item = (Item)BuiltInRegistries.ITEM.getValue(parameters.id().value());
            if (cost.getItemStack().getItem() != item) {
                cost.setItemStack(new ItemStack((ItemLike)item));
                cost.setCount((int)parameters.count().value());
            } else {
                cost.setCount(Math.min(cost.getCount(), (int)parameters.count().value()));
            }
            return cost;
        }, () -> true);
        RuleRegistry.registerModifier("refuse", RuleRegistry.createDefaultType("refuse", RefuseRequirement.class), ComponentParameter.class, (cost, context, parameters) -> {
            cost.setMessage(parameters.value());
            return cost;
        }, () -> true);
    }
}

