/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.unbreakables.rules.hint;

import java.util.ArrayList;
import java.util.List;
import net.blay09.mods.unbreakables.api.BreakHint;
import net.blay09.mods.unbreakables.rules.hint.BreakHintRegistry;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.resources.Identifier;

public record CombinedHint(List<? extends BreakHint<?>> hints) implements BreakHint<CombinedHint>
{
    public static final Identifier ID = Identifier.fromNamespaceAndPath((String)"unbreakables", (String)"multiple");

    @Override
    public Identifier id() {
        return ID;
    }

    @Override
    public BreakHint.Serializer<CombinedHint> serializer() {
        return CombinedBreakHintSerializer.INSTANCE;
    }

    public static class CombinedBreakHintSerializer
    implements BreakHint.Serializer<CombinedHint> {
        public static final CombinedBreakHintSerializer INSTANCE = new CombinedBreakHintSerializer();

        @Override
        public void encode(RegistryFriendlyByteBuf buf, CombinedHint hint) {
            buf.writeVarInt(hint.hints().size());
            for (BreakHint<?> child : hint.hints()) {
                buf.writeIdentifier(child.id());
                BreakHint.Serializer<?> serializer = child.serializer();
                serializer.encode(buf, child);
            }
        }

        @Override
        public CombinedHint decode(RegistryFriendlyByteBuf buf) {
            int size = buf.readVarInt();
            ArrayList hints = new ArrayList(size);
            for (int i = 0; i < size; ++i) {
                Identifier id = buf.readIdentifier();
                BreakHint.Serializer<BreakHint<?>> serializer = BreakHintRegistry.getSerializer(id);
                BreakHint<?> hint = serializer.decode(buf);
                hints.add(hint);
            }
            return new CombinedHint(hints);
        }
    }
}

