/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.unbreakables.rules.requirements;

import java.util.Collection;
import java.util.Optional;
import net.blay09.mods.unbreakables.api.BreakContext;
import net.blay09.mods.unbreakables.api.BreakHint;
import net.blay09.mods.unbreakables.api.BreakRequirement;
import net.blay09.mods.unbreakables.rules.hint.CombinedHint;
import net.minecraft.world.entity.player.Player;

public record CombinedRequirement(Collection<BreakRequirement> requirements) implements BreakRequirement
{
    @Override
    public boolean canAfford(BreakContext context, Player player) {
        return this.requirements.stream().allMatch(requirement -> requirement.canAfford(context, player));
    }

    @Override
    public void consume(Player player) {
        this.requirements.forEach(requirement -> requirement.consume(player));
    }

    @Override
    public void rollback(Player player) {
        this.requirements.forEach(requirement -> requirement.rollback(player));
    }

    @Override
    public Optional<BreakHint<?>> hint(BreakContext context, Player player) {
        return Optional.of(new CombinedHint(this.requirements.stream().map(it -> it.hint(context, player)).filter(Optional::isPresent).map(Optional::get).toList()));
    }

    @Override
    public boolean isEmpty() {
        return this.requirements.stream().allMatch(BreakRequirement::isEmpty);
    }
}

