/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.unbreakables.rules.requirements;

import java.util.Optional;
import net.blay09.mods.unbreakables.CooldownTracker;
import net.blay09.mods.unbreakables.api.BreakContext;
import net.blay09.mods.unbreakables.api.BreakHint;
import net.blay09.mods.unbreakables.api.BreakRequirement;
import net.blay09.mods.unbreakables.rules.hint.CooldownHint;
import net.minecraft.resources.Identifier;
import net.minecraft.world.entity.player.Player;

public class CooldownRequirement
implements BreakRequirement {
    private Identifier id;
    private int seconds;

    public CooldownRequirement(Identifier id, int seconds) {
        this.id = id;
        this.seconds = seconds;
    }

    @Override
    public boolean canAfford(BreakContext context, Player player) {
        return context.viaServer(level -> this.getCooldownMillisLeft(player) <= 0L);
    }

    @Override
    public void consume(Player player) {
        if (this.seconds > 0) {
            CooldownTracker.setCooldownUntil(player, this.id, System.currentTimeMillis() + (long)this.seconds * 1000L);
        }
    }

    @Override
    public void rollback(Player player) {
        CooldownTracker.setCooldownUntil(player, this.id, 0L);
    }

    @Override
    public Optional<BreakHint<?>> hint(BreakContext context, Player player) {
        long secondsLeft = this.getCooldownMillisLeft(player) / 1000L;
        return Optional.of(new CooldownHint((int)secondsLeft));
    }

    private long getCooldownMillisLeft(Player player) {
        return CooldownTracker.getCooldownMillisLeft(player, this.id);
    }

    @Override
    public boolean isEmpty() {
        return this.seconds <= 0;
    }

    public void setCooldown(Identifier key, int seconds) {
        this.id = key;
        this.seconds = seconds;
    }

    public Identifier getCooldownId() {
        return this.id;
    }

    public int getCooldownSeconds() {
        return this.seconds;
    }
}

